/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildoption;

import java.util.Map;
import org.gradle.internal.buildoption.InternalOption;
import org.gradle.internal.buildoption.InternalOptions;
import org.gradle.internal.buildoption.Option;

public class DefaultInternalOptions
implements InternalOptions {
    private final Map<String, String> properties;

    public DefaultInternalOptions(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public <T> Option.Value<T> getOption(InternalOption<T> option) {
        String value = this.properties.get(option.getPropertyName());
        if (value == null) {
            value = System.getProperty(option.getPropertyName());
        }
        if (value == null) {
            return Option.Value.defaultValue(option.getDefaultValue());
        }
        return Option.Value.value(option.convert(value));
    }
}

