/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.io.vavr.collection;

import java.util.function.ToDoubleFunction;

interface TraversableModule {
    public static <T> double[] neumaierSum(Iterable<T> ts, ToDoubleFunction<T> toDouble) {
        double simpleSum = 0.0;
        double sum = 0.0;
        double compensation = 0.0;
        int size = 0;
        for (T t2 : ts) {
            double d2 = toDouble.applyAsDouble(t2);
            double tmp = sum + d2;
            compensation += Math.abs(sum) >= Math.abs(d2) ? sum - tmp + d2 : d2 - tmp + sum;
            sum = tmp;
            simpleSum += d2;
            ++size;
        }
        if (size > 0 && Double.isNaN(sum += compensation) && Double.isInfinite(simpleSum)) {
            sum = simpleSum;
        }
        return new double[]{sum, size};
    }
}

