/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import javax.inject.Inject;
import org.gradle.api.internal.tasks.compile.daemon.CompilerParameters;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.Cast;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.workers.WorkAction;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.ProvidesWorkResult;

public class CompilerWorkAction
implements WorkAction<CompilerParameters>,
ProvidesWorkResult {
    private DefaultWorkResult workResult;
    private final CompilerParameters parameters;
    private final Instantiator instantiator;

    @Inject
    public CompilerWorkAction(CompilerParameters parameters, Instantiator instantiator) {
        this.parameters = parameters;
        this.instantiator = instantiator;
    }

    public CompilerParameters getParameters() {
        return this.parameters;
    }

    public void execute() {
        Class compilerClass = (Class)Cast.uncheckedCast((Object)ClassLoaderUtils.classFromContextLoader((String)this.getParameters().getCompilerClassName()));
        Compiler compiler = (Compiler)this.instantiator.newInstance(compilerClass, this.getParameters().getCompilerInstanceParameters());
        this.setWorkResult(compiler.execute((CompileSpec)Cast.uncheckedCast((Object)this.getParameters().getCompileSpec())));
    }

    private void setWorkResult(WorkResult workResult) {
        this.workResult = workResult instanceof DefaultWorkResult ? (DefaultWorkResult)workResult : new DefaultWorkResult(workResult.getDidWork(), null);
    }

    public DefaultWorkResult getWorkResult() {
        return this.workResult;
    }
}

