/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Buildable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.initialization.BuildLogicBuildQueue;
import org.gradle.api.internal.initialization.BuildLogicBuilder;
import org.gradle.api.internal.initialization.ScriptClassPathResolutionContext;
import org.gradle.api.internal.initialization.ScriptClassPathResolver;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskDependencyUtil;
import org.gradle.composite.internal.TaskIdentifier;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;

public class DefaultBuildLogicBuilder
implements BuildLogicBuilder {
    private final BuildState currentBuild;
    private final ScriptClassPathResolver scriptClassPathResolver;
    private final BuildLogicBuildQueue buildQueue;
    private final BuildOperationRunner buildOperationRunner;

    public DefaultBuildLogicBuilder(BuildState currentBuild, ScriptClassPathResolver scriptClassPathResolver, BuildLogicBuildQueue buildQueue, BuildOperationRunner buildOperationRunner) {
        this.currentBuild = currentBuild;
        this.scriptClassPathResolver = scriptClassPathResolver;
        this.buildQueue = buildQueue;
        this.buildOperationRunner = buildOperationRunner;
    }

    @Override
    public ScriptClassPathResolutionContext prepareDependencyHandler(DependencyHandler dependencyHandler) {
        return this.scriptClassPathResolver.prepareDependencyHandler(dependencyHandler);
    }

    @Override
    public void prepareClassPath(Configuration classpathConfiguration, ScriptClassPathResolutionContext resolutionContext) {
        this.scriptClassPathResolver.prepareClassPath(classpathConfiguration, resolutionContext);
    }

    @Override
    public ClassPath resolveClassPath(final Configuration classpathConfiguration, final ScriptClassPathResolutionContext resolutionContext) {
        return (ClassPath)this.buildOperationRunner.call((CallableBuildOperation)new CallableBuildOperation<ClassPath>(){

            public ClassPath call(BuildOperationContext context) {
                return DefaultBuildLogicBuilder.this.buildQueue.build(DefaultBuildLogicBuilder.this.currentBuild, DefaultBuildLogicBuilder.this.taskIdentifiersForBuildDependenciesOf(classpathConfiguration), () -> DefaultBuildLogicBuilder.this.scriptClassPathResolver.resolveClassPath(classpathConfiguration, resolutionContext));
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)("Resolve buildscript classpath for " + classpathConfiguration));
            }
        });
    }

    private List<TaskIdentifier.TaskBasedTaskIdentifier> taskIdentifiersForBuildDependenciesOf(Configuration classpath) {
        ArrayList<TaskIdentifier.TaskBasedTaskIdentifier> tasksToBuild = new ArrayList<TaskIdentifier.TaskBasedTaskIdentifier>();
        for (Task task : TaskDependencyUtil.getDependenciesForInternalUse((Buildable)classpath)) {
            BuildState targetBuild = DefaultBuildLogicBuilder.owningBuildOf(task);
            if (targetBuild == this.currentBuild) {
                throw new InvalidUserDataException("Script classpath dependencies must reside in a separate build from the script itself.");
            }
            tasksToBuild.add(TaskIdentifier.of(targetBuild.getBuildIdentifier(), (TaskInternal)task));
        }
        return tasksToBuild;
    }

    private static BuildState owningBuildOf(Task task) {
        return ((ProjectInternal)task.getProject()).getOwner().getOwner();
    }
}

