/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmCompiledFileFragment;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFileCodegenContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmServiceImportExportKind;
import org.jetbrains.kotlin.ir.declarations.IdSignatureRetriever;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmImportDescriptor;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u001a\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0012H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContextWithImport;", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContext;", "wasmFileFragment", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledFileFragment;", "idSignatureRetriever", "Lorg/jetbrains/kotlin/ir/declarations/IdSignatureRetriever;", "moduleName", "", "importDeclarations", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledFileFragment;Lorg/jetbrains/kotlin/ir/declarations/IdSignatureRetriever;Ljava/lang/String;Ljava/util/Set;)V", "handleFunctionWithImport", "", "declaration", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "handleVTableWithImport", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "handleClassITableWithImport", "handleRTTIWithImport", "superType", "backend.wasm"})
public final class WasmFileCodegenContextWithImport
extends WasmFileCodegenContext {
    @NotNull
    private final String moduleName;
    @NotNull
    private final Set<IdSignature> importDeclarations;

    public WasmFileCodegenContextWithImport(@NotNull WasmCompiledFileFragment wasmFileFragment, @NotNull IdSignatureRetriever idSignatureRetriever, @NotNull String moduleName2, @NotNull Set<? extends IdSignature> importDeclarations) {
        Intrinsics.checkNotNullParameter((Object)wasmFileFragment, (String)"wasmFileFragment");
        Intrinsics.checkNotNullParameter((Object)idSignatureRetriever, (String)"idSignatureRetriever");
        Intrinsics.checkNotNullParameter((Object)moduleName2, (String)"moduleName");
        Intrinsics.checkNotNullParameter(importDeclarations, (String)"importDeclarations");
        super(wasmFileFragment, idSignatureRetriever);
        this.moduleName = moduleName2;
        this.importDeclarations = importDeclarations;
    }

    @Override
    public boolean handleFunctionWithImport(@NotNull IrFunctionSymbol declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IdSignature signature = this.getIdSignatureRetriever().declarationSignature(declaration.getOwner());
        if (!CollectionsKt.contains((Iterable)this.importDeclarations, (Object)signature)) {
            return true;
        }
        WasmSymbol<WasmFunctionType> functionTypeSymbol = this.referenceFunctionType(declaration);
        this.defineFunction(declaration, new WasmFunction.Imported(String.valueOf(IrUtilsKt.getFqNameWhenAvailable(declaration.getOwner())), (WasmSymbolReadOnly<WasmFunctionType>)functionTypeSymbol, new WasmImportDescriptor(this.moduleName, (WasmSymbolReadOnly<String>)new WasmSymbol<String>(WasmServiceImportExportKind.FUNC.getPrefix() + signature))));
        return true;
    }

    @Override
    public boolean handleVTableWithImport(@NotNull IrClassSymbol declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IdSignature signature = this.getIdSignatureRetriever().declarationSignature((IrDeclaration)declaration.getOwner());
        if (!CollectionsKt.contains((Iterable)this.importDeclarations, (Object)signature)) {
            return true;
        }
        WasmGlobal global = new WasmGlobal("<classVTable>", new WasmRefType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.referenceVTableGcType(declaration))), false, CollectionsKt.emptyList(), new WasmImportDescriptor(this.moduleName, (WasmSymbolReadOnly<String>)new WasmSymbol<String>(WasmServiceImportExportKind.VTABLE.getPrefix() + signature)));
        this.defineGlobalVTable(declaration, global);
        return true;
    }

    @Override
    public boolean handleClassITableWithImport(@NotNull IrClassSymbol declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IdSignature signature = this.getIdSignatureRetriever().declarationSignature((IrDeclaration)declaration.getOwner());
        if (!CollectionsKt.contains((Iterable)this.importDeclarations, (Object)signature)) {
            return true;
        }
        WasmGlobal global = new WasmGlobal("<classITable>", new WasmRefType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.getInterfaceTableTypes().getWasmAnyArrayType())), false, CollectionsKt.emptyList(), new WasmImportDescriptor(this.moduleName, (WasmSymbolReadOnly<String>)new WasmSymbol<String>(WasmServiceImportExportKind.ITABLE.getPrefix() + signature)));
        this.defineGlobalClassITable(declaration, global);
        return true;
    }

    @Override
    public boolean handleRTTIWithImport(@NotNull IrClassSymbol declaration, @Nullable IrClassSymbol superType) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IdSignature signature = this.getIdSignatureRetriever().declarationSignature((IrDeclaration)declaration.getOwner());
        if (!CollectionsKt.contains((Iterable)this.importDeclarations, (Object)signature)) {
            return true;
        }
        WasmGlobal rttiGlobal = new WasmGlobal(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)declaration.getOwner()) + "_rtti", new WasmRefType(new WasmHeapType.Type((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)this.getRttiType())), false, CollectionsKt.emptyList(), new WasmImportDescriptor(this.moduleName, (WasmSymbolReadOnly<String>)new WasmSymbol<String>(WasmServiceImportExportKind.RTTI.getPrefix() + signature)));
        this.defineRttiGlobal(rttiGlobal, declaration, superType);
        return true;
    }
}

