/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.ConsumableConfiguration;
import org.gradle.api.artifacts.DependencyScopeConfiguration;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponentFactory;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.capabilities.CapabilityInternal;
import org.gradle.api.internal.java.DefaultJavaPlatformExtension;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.JavaPlatformExtension;
import org.gradle.api.plugins.JvmEcosystemPlugin;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.internal.component.external.model.ProjectDerivedCapability;
import org.gradle.internal.component.external.model.ShadowedImmutableCapability;

public abstract class JavaPlatformPlugin
implements Plugin<Project> {
    public static final String API_CONFIGURATION_NAME = "api";
    public static final String RUNTIME_CONFIGURATION_NAME = "runtime";
    public static final String API_ELEMENTS_CONFIGURATION_NAME = "apiElements";
    public static final String RUNTIME_ELEMENTS_CONFIGURATION_NAME = "runtimeElements";
    public static final String ENFORCED_API_ELEMENTS_CONFIGURATION_NAME = "enforcedApiElements";
    public static final String ENFORCED_RUNTIME_ELEMENTS_CONFIGURATION_NAME = "enforcedRuntimeElements";
    public static final String CLASSPATH_CONFIGURATION_NAME = "classpath";
    private final SoftwareComponentFactory softwareComponentFactory;

    @Inject
    public JavaPlatformPlugin(SoftwareComponentFactory softwareComponentFactory) {
        this.softwareComponentFactory = softwareComponentFactory;
    }

    public void apply(Project project) {
        if (project.getPluginManager().hasPlugin("java")) {
            throw new IllegalStateException("The \"java-platform\" plugin cannot be applied together with the \"java\" (or \"java-library\") plugin. A project is either a platform or a library but cannot be both at the same time.");
        }
        project.getPluginManager().apply(BasePlugin.class);
        project.getPluginManager().apply(JvmEcosystemPlugin.class);
        this.createConfigurations((ProjectInternal)project);
        this.configureExtension(project);
        this.configurePublishing(project);
    }

    private void createSoftwareComponent(Project project, Provider<ConsumableConfiguration> apiElements, Provider<ConsumableConfiguration> runtimeElements) {
        AdhocComponentWithVariants component = this.softwareComponentFactory.adhoc("javaPlatform");
        project.getComponents().add((Object)component);
        component.addVariantsFromConfiguration(apiElements, (Action)new JavaConfigurationVariantMapping("compile", false));
        component.addVariantsFromConfiguration(runtimeElements, (Action)new JavaConfigurationVariantMapping(RUNTIME_CONFIGURATION_NAME, false));
    }

    private void createConfigurations(ProjectInternal project) {
        RoleBasedConfigurationContainerInternal configurations = project.getConfigurations();
        ShadowedImmutableCapability enforcedCapability = new ShadowedImmutableCapability((CapabilityInternal)new ProjectDerivedCapability(project), "-derived-enforced-platform");
        DependencyScopeConfiguration api = configurations.dependencyScopeLocked(API_CONFIGURATION_NAME);
        Provider<ConsumableConfiguration> apiElements = this.createConsumableApi(project, (Configuration)api, API_ELEMENTS_CONFIGURATION_NAME, "platform", Collections.emptySet());
        this.createConsumableApi(project, (Configuration)api, ENFORCED_API_ELEMENTS_CONFIGURATION_NAME, "enforced-platform", Collections.singleton(enforcedCapability));
        DependencyScopeConfiguration runtime = project.getConfigurations().dependencyScopeLocked(RUNTIME_CONFIGURATION_NAME, arg_0 -> JavaPlatformPlugin.lambda$createConfigurations$0((Configuration)api, arg_0));
        Provider<ConsumableConfiguration> runtimeElements = this.createConsumableRuntime(project, (Configuration)runtime, RUNTIME_ELEMENTS_CONFIGURATION_NAME, "platform", Collections.emptySet());
        this.createConsumableRuntime(project, (Configuration)runtime, ENFORCED_RUNTIME_ELEMENTS_CONFIGURATION_NAME, "enforced-platform", Collections.singleton(enforcedCapability));
        configurations.resolvableLocked(CLASSPATH_CONFIGURATION_NAME, arg_0 -> this.lambda$createConfigurations$1((Configuration)runtime, arg_0));
        this.createSoftwareComponent((Project)project, apiElements, runtimeElements);
    }

    private Provider<ConsumableConfiguration> createConsumableRuntime(ProjectInternal project, Configuration runtime, String name, String platformKind, Set<Capability> capabilities) {
        return project.getConfigurations().consumable(name, runtimeElements -> {
            runtimeElements.extendsFrom(new Configuration[]{runtime});
            this.declareConfigurationUsage((Configuration)runtimeElements, "java-runtime");
            this.declareConfigurationCategory((Configuration)runtimeElements, platformKind);
            ConfigurationPublications outgoing = runtimeElements.getOutgoing();
            capabilities.forEach(arg_0 -> ((ConfigurationPublications)outgoing).capability(arg_0));
        });
    }

    private Provider<ConsumableConfiguration> createConsumableApi(ProjectInternal project, Configuration api, String name, String platformKind, Set<Capability> capabilities) {
        return project.getConfigurations().consumable(name, apiElements -> {
            apiElements.extendsFrom(new Configuration[]{api});
            this.declareConfigurationUsage((Configuration)apiElements, "java-api");
            this.declareConfigurationCategory((Configuration)apiElements, platformKind);
            ConfigurationPublications outgoing = apiElements.getOutgoing();
            capabilities.forEach(arg_0 -> ((ConfigurationPublications)outgoing).capability(arg_0));
        });
    }

    private void declareConfigurationCategory(Configuration configuration, String value) {
        AttributeContainer attributes = configuration.getAttributes();
        attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)attributes.named(Category.class, value)));
    }

    private void declareConfigurationLibraryElements(Configuration configuration, String libraryContents) {
        AttributeContainer attributes = configuration.getAttributes();
        attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)attributes.named(LibraryElements.class, libraryContents)));
    }

    private void declareConfigurationUsage(Configuration configuration, String usage) {
        AttributeContainer attributes = configuration.getAttributes();
        attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)attributes.named(Usage.class, usage)));
    }

    private void configureExtension(Project project) {
        DefaultJavaPlatformExtension platformExtension = (DefaultJavaPlatformExtension)project.getExtensions().create(JavaPlatformExtension.class, "javaPlatform", DefaultJavaPlatformExtension.class, new Object[0]);
        project.afterEvaluate(project1 -> {
            if (!platformExtension.isAllowDependencies()) {
                this.checkNoDependencies((Project)project1);
            }
        });
    }

    private void checkNoDependencies(Project project) {
        this.checkNoDependencies(project.getConfigurations().getByName(RUNTIME_CONFIGURATION_NAME), new HashSet<Configuration>());
    }

    private void checkNoDependencies(Configuration configuration, Set<Configuration> visited) {
        if (visited.add(configuration)) {
            if (!configuration.getDependencies().isEmpty()) {
                throw new InvalidUserCodeException(String.format("Adding dependencies to platforms is not allowed by default.\nMost likely you want to add constraints instead.\nIf you did this intentionally, you need to configure the platform extension to allow dependencies:\n    javaPlatform.allowDependencies()\nFound dependencies in the '%s' configuration.", configuration.getName()));
            }
            Set extendsFrom = configuration.getExtendsFrom();
            for (Configuration parent : extendsFrom) {
                this.checkNoDependencies(parent, visited);
            }
        }
    }

    private void configurePublishing(Project project) {
        project.getPlugins().withType(PublishingPlugin.class, plugin -> {
            PublishingExtension publishing = (PublishingExtension)project.getExtensions().getByType(PublishingExtension.class);
            publishing.getPublications().withType(IvyPublication.class, publication -> {
                VersionMappingStrategyInternal strategy = ((PublicationInternal)publication).getVersionMappingStrategy();
                strategy.defaultResolutionConfiguration("java-api", CLASSPATH_CONFIGURATION_NAME);
                strategy.defaultResolutionConfiguration("java-runtime", CLASSPATH_CONFIGURATION_NAME);
            });
            publishing.getPublications().withType(MavenPublication.class, publication -> {
                VersionMappingStrategyInternal strategy = ((PublicationInternal)publication).getVersionMappingStrategy();
                strategy.defaultResolutionConfiguration("java-api", CLASSPATH_CONFIGURATION_NAME);
                strategy.defaultResolutionConfiguration("java-runtime", CLASSPATH_CONFIGURATION_NAME);
            });
        });
    }

    private /* synthetic */ void lambda$createConfigurations$1(Configuration runtime, Configuration conf) {
        conf.extendsFrom(new Configuration[]{runtime});
        this.declareConfigurationUsage(conf, "java-runtime");
        this.declareConfigurationLibraryElements(conf, "jar");
    }

    private static /* synthetic */ void lambda$createConfigurations$0(Configuration api, Configuration conf) {
        conf.extendsFrom(new Configuration[]{api});
    }
}

