/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.accessors;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.kotlin.dsl.accessors.AccessorsClassPathKt;
import org.gradle.kotlin.dsl.accessors.ClassNamesFromTypeString;
import org.gradle.kotlin.dsl.accessors.HasTypeParameterClassVisitor;
import org.gradle.kotlin.dsl.accessors.InaccessibilityReason;
import org.gradle.kotlin.dsl.accessors.KotlinVisibilityClassVisitor;
import org.gradle.kotlin.dsl.accessors.OptInAnnotationsCollector;
import org.gradle.kotlin.dsl.accessors.OptInRequirements;
import org.gradle.kotlin.dsl.accessors.SchemaType;
import org.gradle.kotlin.dsl.accessors.TypeAccessibility;
import org.gradle.kotlin.dsl.accessors.TypeAccessibilityInfo;
import org.gradle.kotlin.dsl.internal.sharedruntime.support.ClassBytesRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0002J$\u0010#\u001a\u0002H$\"\b\b\u0000\u0010$*\u00020%*\u00020!2\u0006\u0010&\u001a\u0002H$H\u0082\u0002\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020)H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+\u00b2\u0006\n\u0010,\u001a\u00020\u001fX\u008a\u0084\u0002"}, d2={"Lorg/gradle/kotlin/dsl/accessors/TypeAccessibilityProvider;", "Ljava/io/Closeable;", "classPath", "Lorg/gradle/internal/classpath/ClassPath;", "<init>", "(Lorg/gradle/internal/classpath/ClassPath;)V", "classBytesRepository", "Lorg/gradle/kotlin/dsl/internal/sharedruntime/support/ClassBytesRepository;", "typeAccessibilityInfoPerClass", "", "", "Lorg/gradle/kotlin/dsl/accessors/TypeAccessibilityInfo;", "optInRequirementsPerClass", "Lorg/gradle/kotlin/dsl/accessors/OptInRequirements;", "optInCollector", "Lorg/gradle/kotlin/dsl/accessors/OptInAnnotationsCollector;", "accessibilityForType", "Lorg/gradle/kotlin/dsl/accessors/TypeAccessibility;", "type", "Lorg/gradle/kotlin/dsl/accessors/SchemaType;", "inaccessibilityReasonsFor", "", "Lorg/gradle/kotlin/dsl/accessors/InaccessibilityReason;", "classNames", "Lorg/gradle/kotlin/dsl/accessors/ClassNamesFromTypeString;", "className", "hasTypeParameter", "", "accessibilityInfoFor", "loadAccessibilityInfoFor", "kotlinVisibilityAndDeprecationFor", "Lorg/gradle/kotlin/dsl/accessors/TypeAccessibilityProvider$VisibilityAndDeprecation;", "classReader", "Lorg/jetbrains/org/objectweb/asm/ClassReader;", "hasTypeParameters", "invoke", "T", "Lorg/jetbrains/org/objectweb/asm/ClassVisitor;", "visitor", "(Lorg/jetbrains/org/objectweb/asm/ClassReader;Lorg/jetbrains/org/objectweb/asm/ClassVisitor;)Lorg/jetbrains/org/objectweb/asm/ClassVisitor;", "close", "", "VisibilityAndDeprecation", "kotlin-dsl", "visibilityAndDeprecation"})
@SourceDebugExtension(value={"SMAP\nAccessorsClassPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessorsClassPath.kt\norg/gradle/kotlin/dsl/accessors/TypeAccessibilityProvider\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,787:1\n383#2,7:788\n1586#3:795\n1661#3,3:796\n1391#3:799\n1480#3,5:800\n777#3:806\n873#3,2:807\n1586#3:809\n1661#3,3:810\n1#4:805\n*S KotlinDebug\n*F\n+ 1 AccessorsClassPath.kt\norg/gradle/kotlin/dsl/accessors/TypeAccessibilityProvider\n*L\n409#1:788,7\n411#1:795\n411#1:796,3\n422#1:799\n422#1:800,5\n423#1:806\n423#1:807,2\n423#1:809\n423#1:810,3\n*E\n"})
public final class TypeAccessibilityProvider
implements Closeable {
    @NotNull
    private final ClassBytesRepository classBytesRepository;
    @NotNull
    private final Map<String, TypeAccessibilityInfo> typeAccessibilityInfoPerClass;
    @NotNull
    private final Map<String, OptInRequirements> optInRequirementsPerClass;
    @NotNull
    private final OptInAnnotationsCollector optInCollector;

    public TypeAccessibilityProvider(@NotNull ClassPath classPath) {
        Intrinsics.checkNotNullParameter((Object)classPath, (String)"classPath");
        ClassLoader classLoader = ClassLoaderUtils.getPlatformClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getPlatformClassLoader(...)");
        List list = classPath.getAsFiles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAsFiles(...)");
        this.classBytesRepository = new ClassBytesRepository(classLoader, list, null, 4, null);
        this.typeAccessibilityInfoPerClass = new LinkedHashMap();
        this.optInRequirementsPerClass = new LinkedHashMap();
        this.optInCollector = new OptInAnnotationsCollector(this.classBytesRepository, (Function1<? super SchemaType, ? extends List<? extends InaccessibilityReason>>)((Function1)new Function1<SchemaType, List<? extends InaccessibilityReason>>((Object)this){

            public final List<InaccessibilityReason> invoke(SchemaType p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return TypeAccessibilityProvider.access$inaccessibilityReasonsFor((TypeAccessibilityProvider)this.receiver, p0);
            }
        }), (Function2<? super String, ? super Function0<? extends OptInRequirements>, ? extends OptInRequirements>)((Function2)new Function2<String, Function0<? extends OptInRequirements>, OptInRequirements>(this.optInRequirementsPerClass){

            /*
             * WARNING - void declaration
             */
            public final OptInRequirements invoke(String p0, Function0<? extends OptInRequirements> p1) {
                Object object;
                void $this$getOrPut$iv;
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Map map2 = (Map)this.receiver;
                String key$iv = p0;
                boolean $i$f$getOrPut = false;
                V value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    Object answer$iv = p1.invoke();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                return (OptInRequirements)object;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeAccessibility accessibilityForType(@NotNull SchemaType type) {
        TypeAccessibility typeAccessibility;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        List<InaccessibilityReason> inaccessibilityReasons = this.inaccessibilityReasonsFor(type);
        boolean bl = false;
        if (!((Collection)inaccessibilityReasons).isEmpty()) {
            typeAccessibility = AccessorsClassPathKt.inaccessible(type, inaccessibilityReasons);
        } else {
            OptInRequirements optIns;
            Object object;
            Iterable $this$getOrPut$iv;
            Map<String, OptInRequirements> map2 = this.optInRequirementsPerClass;
            String key$iv = type.getKotlinString();
            boolean $i$f$getOrPut2 = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                OptInRequirements answer$iv = this.optInCollector.collectOptInRequirementAnnotationsForType(type);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            if ((optIns = (OptInRequirements)object) instanceof OptInRequirements.Annotations) {
                typeAccessibility = AccessorsClassPathKt.accessible(type, ((OptInRequirements.Annotations)optIns).getAnnotations());
            } else if (optIns instanceof OptInRequirements.Unsatisfiable) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                $this$getOrPut$iv = ((OptInRequirements.Unsatisfiable)optIns).getBecauseOfTypes();
                SchemaType schemaType = type;
                boolean $i$f$map = false;
                void $i$f$getOrPut2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(new InaccessibilityReason.RequiresUnsatisfiableOptIns((String)it));
                }
                typeAccessibility = AccessorsClassPathKt.inaccessible(schemaType, (List)destination$iv$iv);
            } else if (Intrinsics.areEqual((Object)optIns, (Object)OptInRequirements.None.INSTANCE)) {
                typeAccessibility = AccessorsClassPathKt.accessible$default(type, null, 2, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return typeAccessibility;
    }

    private final List<InaccessibilityReason> inaccessibilityReasonsFor(SchemaType type) {
        return this.inaccessibilityReasonsFor(AccessorsClassPathKt.classNamesFromTypeString(type));
    }

    /*
     * WARNING - void declaration
     */
    private final List<InaccessibilityReason> inaccessibilityReasonsFor(ClassNamesFromTypeString classNames) {
        Collection collection;
        Iterable list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = classNames.getAll();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.inaccessibilityReasonsFor(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List inaccessibilityReasons = (List)destination$iv$iv;
        boolean bl = false;
        Collection collection2 = inaccessibilityReasons;
        if (collection2.isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String p0;
            void $this$filterTo$iv$iv;
            boolean bl2 = false;
            Iterable $this$filter$iv = classNames.getLeaves();
            boolean $i$f$filter = false;
            list$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                p0 = (String)element$iv$iv;
                boolean bl3 = false;
                if (!this.hasTypeParameter(p0)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                p0 = (String)item$iv$iv;
                Collection collection3 = destination$iv$iv2;
                boolean bl4 = false;
                collection3.add(AccessorsClassPathKt.typeErasure(p0));
            }
            collection = (List)destination$iv$iv2;
        } else {
            collection = collection2;
        }
        return (List)collection;
    }

    private final List<InaccessibilityReason> inaccessibilityReasonsFor(String className) {
        return this.accessibilityInfoFor(className).getInaccessibilityReasons();
    }

    private final boolean hasTypeParameter(String className) {
        return this.accessibilityInfoFor(className).getHasTypeParameter();
    }

    private final TypeAccessibilityInfo accessibilityInfoFor(String className) {
        TypeAccessibilityInfo typeAccessibilityInfo = this.typeAccessibilityInfoPerClass.computeIfAbsent(className, new Function(this){
            final /* synthetic */ TypeAccessibilityProvider this$0;
            {
                this.this$0 = $receiver;
            }

            public final TypeAccessibilityInfo apply(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return TypeAccessibilityProvider.access$loadAccessibilityInfoFor(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)typeAccessibilityInfo, (String)"computeIfAbsent(...)");
        return typeAccessibilityInfo;
    }

    private final TypeAccessibilityInfo loadAccessibilityInfoFor(String className) {
        byte[] byArray = this.classBytesRepository.classBytesFor(className);
        if (byArray == null) {
            return new TypeAccessibilityInfo(CollectionsKt.listOf((Object)AccessorsClassPathKt.nonAvailable(className)), false, 2, null);
        }
        byte[] classBytes = byArray;
        ClassReader classReader = new ClassReader(classBytes);
        int access = classReader.getAccess();
        Lazy visibilityAndDeprecation$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> TypeAccessibilityProvider.loadAccessibilityInfoFor$lambda$0(this, classReader));
        return new TypeAccessibilityInfo(CollectionsKt.listOfNotNull((Object)(!AccessorsClassPathKt.access$contains(access, 1) ? AccessorsClassPathKt.nonPublic(className) : (AccessorsClassPathKt.access$contains(access, 4096) ? AccessorsClassPathKt.synthetic(className) : (TypeAccessibilityProvider.loadAccessibilityInfoFor$lambda$1((Lazy<VisibilityAndDeprecation>)visibilityAndDeprecation$delegate).isNonPublicType() ? AccessorsClassPathKt.nonPublic(className) : (TypeAccessibilityProvider.loadAccessibilityInfoFor$lambda$1((Lazy<VisibilityAndDeprecation>)visibilityAndDeprecation$delegate).isDeprecatedAsHidden() ? AccessorsClassPathKt.deprecatedAsHidden(className) : null))))), this.hasTypeParameters(classReader));
    }

    private final VisibilityAndDeprecation kotlinVisibilityAndDeprecationFor(ClassReader classReader) {
        KotlinVisibilityClassVisitor $this$kotlinVisibilityAndDeprecationFor_u24lambda_u240 = (KotlinVisibilityClassVisitor)this.invoke(classReader, (ClassVisitor)new KotlinVisibilityClassVisitor());
        boolean bl = false;
        return new VisibilityAndDeprecation($this$kotlinVisibilityAndDeprecationFor_u24lambda_u240.getVisibility() != null && $this$kotlinVisibilityAndDeprecationFor_u24lambda_u240.getVisibility() != ProtoBuf.Visibility.PUBLIC, $this$kotlinVisibilityAndDeprecationFor_u24lambda_u240.isDeprecatedAsHidden());
    }

    private final boolean hasTypeParameters(ClassReader classReader) {
        return ((HasTypeParameterClassVisitor)this.invoke(classReader, (ClassVisitor)new HasTypeParameterClassVisitor())).getHasTypeParameters();
    }

    private final <T extends ClassVisitor> T invoke(ClassReader $this$invoke, T visitor) {
        T t;
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"<this>");
        T it = t = visitor;
        boolean bl = false;
        $this$invoke.accept(it, 7);
        return t;
    }

    @Override
    public void close() {
        this.classBytesRepository.close();
    }

    private static final VisibilityAndDeprecation loadAccessibilityInfoFor$lambda$1(Lazy<VisibilityAndDeprecation> $visibilityAndDeprecation$delegate) {
        Lazy<VisibilityAndDeprecation> lazy = $visibilityAndDeprecation$delegate;
        return (VisibilityAndDeprecation)lazy.getValue();
    }

    private static final VisibilityAndDeprecation loadAccessibilityInfoFor$lambda$0(TypeAccessibilityProvider this$0, ClassReader $classReader) {
        return this$0.kotlinVisibilityAndDeprecationFor($classReader);
    }

    public static final /* synthetic */ TypeAccessibilityInfo access$loadAccessibilityInfoFor(TypeAccessibilityProvider $this, String className) {
        return $this.loadAccessibilityInfoFor(className);
    }

    public static final /* synthetic */ List access$inaccessibilityReasonsFor(TypeAccessibilityProvider $this, SchemaType type) {
        return $this.inaccessibilityReasonsFor(type);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u000b\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\r\u001a\u00020\u000eH\u00d6\u0081\u0004J\n\u0010\u000f\u001a\u00020\u0010H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/gradle/kotlin/dsl/accessors/TypeAccessibilityProvider$VisibilityAndDeprecation;", "", "isNonPublicType", "", "isDeprecatedAsHidden", "<init>", "(ZZ)V", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "kotlin-dsl"})
    private static final class VisibilityAndDeprecation {
        private final boolean isNonPublicType;
        private final boolean isDeprecatedAsHidden;

        public VisibilityAndDeprecation(boolean isNonPublicType, boolean isDeprecatedAsHidden) {
            this.isNonPublicType = isNonPublicType;
            this.isDeprecatedAsHidden = isDeprecatedAsHidden;
        }

        public final boolean isNonPublicType() {
            return this.isNonPublicType;
        }

        public final boolean isDeprecatedAsHidden() {
            return this.isDeprecatedAsHidden;
        }

        public final boolean component1() {
            return this.isNonPublicType;
        }

        public final boolean component2() {
            return this.isDeprecatedAsHidden;
        }

        @NotNull
        public final VisibilityAndDeprecation copy(boolean isNonPublicType, boolean isDeprecatedAsHidden) {
            return new VisibilityAndDeprecation(isNonPublicType, isDeprecatedAsHidden);
        }

        public static /* synthetic */ VisibilityAndDeprecation copy$default(VisibilityAndDeprecation visibilityAndDeprecation, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = visibilityAndDeprecation.isNonPublicType;
            }
            if ((n & 2) != 0) {
                bl2 = visibilityAndDeprecation.isDeprecatedAsHidden;
            }
            return visibilityAndDeprecation.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "VisibilityAndDeprecation(isNonPublicType=" + this.isNonPublicType + ", isDeprecatedAsHidden=" + this.isDeprecatedAsHidden + ')';
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.isNonPublicType);
            result = result * 31 + Boolean.hashCode(this.isDeprecatedAsHidden);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VisibilityAndDeprecation)) {
                return false;
            }
            VisibilityAndDeprecation visibilityAndDeprecation = (VisibilityAndDeprecation)other;
            if (this.isNonPublicType != visibilityAndDeprecation.isNonPublicType) {
                return false;
            }
            return this.isDeprecatedAsHidden == visibilityAndDeprecation.isDeprecatedAsHidden;
        }
    }
}

