/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.codeInsight;

import java.util.Arrays;
import java.util.function.IntUnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.FileModificationService;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;

public abstract class CodeInsightUtilCore
extends FileModificationService {
    private static final Logger LOG = Logger.getInstance(CodeInsightUtilCore.class);

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder out, int @Nullable [] sourceOffsets) {
        if (chars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(8);
        }
        if (out == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(9);
        }
        return CodeInsightUtilCore.parseStringCharacters(chars, out, sourceOffsets, true);
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder out, int @Nullable [] sourceOffsets, boolean textBlock) {
        if (chars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(10);
        }
        if (out == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(11);
        }
        LOG.assertTrue(sourceOffsets == null || sourceOffsets.length == chars.length() + 1);
        if (CodeInsightUtilCore.noEscape(chars, sourceOffsets)) {
            out.append(chars);
            return true;
        }
        return CodeInsightUtilCore.parseStringCharactersWithEscape(chars, textBlock, out, sourceOffsets);
    }

    @Nullable
    public static CharSequence parseStringCharacters(@NotNull String chars, int @Nullable [] sourceOffsets) {
        if (chars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(12);
        }
        LOG.assertTrue(sourceOffsets == null || sourceOffsets.length == chars.length() + 1);
        if (CodeInsightUtilCore.noEscape(chars, sourceOffsets)) {
            return chars;
        }
        StringBuilder out = new StringBuilder(chars.length());
        return CodeInsightUtilCore.parseStringCharactersWithEscape(chars, true, out, sourceOffsets) ? out : null;
    }

    private static boolean noEscape(@NotNull String chars, int @Nullable [] sourceOffsets) {
        if (chars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(13);
        }
        if (chars.indexOf(92) >= 0) {
            return false;
        }
        if (sourceOffsets != null) {
            Arrays.setAll(sourceOffsets, IntUnaryOperator.identity());
        }
        return true;
    }

    static boolean parseStringCharactersWithEscape(@NotNull String chars, boolean textBlock, @NotNull StringBuilder out, int @Nullable [] sourceOffsets) {
        if (chars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(14);
        }
        if (out == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(15);
        }
        int index = 0;
        int outOffset = out.length();
        while (index < chars.length()) {
            char c2 = chars.charAt(index++);
            if (sourceOffsets != null) {
                sourceOffsets[out.length() - outOffset] = index - 1;
                sourceOffsets[out.length() + 1 - outOffset] = index;
            }
            if (c2 != '\\') {
                out.append(c2);
                continue;
            }
            if ((index = CodeInsightUtilCore.parseEscapedSymbol(false, chars, index, textBlock, out)) == -1) {
                return false;
            }
            if (sourceOffsets == null) continue;
            sourceOffsets[out.length() - outOffset] = index;
        }
        return true;
    }

    private static int parseEscapedSymbol(boolean isAfterEscapedBackslash, @NotNull String chars, int index, boolean textBlock, @NotNull StringBuilder out) {
        char c2;
        if (chars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(16);
        }
        if (out == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(17);
        }
        if (index == chars.length()) {
            return -1;
        }
        if (CodeInsightUtilCore.parseEscapedChar(c2 = chars.charAt(index++), textBlock, out)) {
            return index;
        }
        switch (c2) {
            case '\\': {
                boolean isUnicodeSequenceStart;
                boolean bl = isUnicodeSequenceStart = isAfterEscapedBackslash && index < chars.length() && chars.charAt(index) == 'u';
                if (isUnicodeSequenceStart) {
                    index = CodeInsightUtilCore.parseUnicodeEscape(true, chars, index, textBlock, out);
                    break;
                }
                out.append('\\');
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                index = CodeInsightUtilCore.parseOctalEscape(c2, chars, index, out);
                break;
            }
            case 'u': {
                if (isAfterEscapedBackslash) {
                    return -1;
                }
                index = CodeInsightUtilCore.parseUnicodeEscape(false, chars, index - 1, textBlock, out);
                break;
            }
            default: {
                return -1;
            }
        }
        return index;
    }

    private static int parseUnicodeEscape(boolean isAfterEscapedBackslash, @NotNull String s2, int index, boolean textBlock, @NotNull StringBuilder out) {
        if (s2 == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(18);
        }
        if (out == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(19);
        }
        int len = s2.length();
        while (++index < len && s2.charAt(index) == 'u') {
        }
        if (index + 4 > len) {
            return -1;
        }
        try {
            char c2 = s2.charAt(index);
            if (c2 == '+' || c2 == '-') {
                return -1;
            }
            int code = Integer.parseInt(s2.substring(index, index + 4), 16);
            if (!(textBlock || code != 10 && code != 13)) {
                return -1;
            }
            char escapedChar = (char)code;
            if (escapedChar == '\\') {
                if (isAfterEscapedBackslash) {
                    out.append('\\');
                    return index + 4;
                }
                return CodeInsightUtilCore.parseEscapedSymbol(true, s2, index + 4, textBlock, out);
            }
            if (isAfterEscapedBackslash) {
                if (CodeInsightUtilCore.parseEscapedChar(escapedChar, textBlock, out)) {
                    return index + 4;
                }
                return -1;
            }
            out.append(escapedChar);
            return index + 4;
        }
        catch (NumberFormatException ignored) {
            return -1;
        }
    }

    private static boolean parseEscapedChar(char c2, boolean textBlock, @NotNull StringBuilder out) {
        if (out == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(20);
        }
        switch (c2) {
            case 'b': {
                out.append('\b');
                return true;
            }
            case 't': {
                out.append('\t');
                return true;
            }
            case 'n': {
                out.append('\n');
                return true;
            }
            case 'f': {
                out.append('\f');
                return true;
            }
            case 'r': {
                out.append('\r');
                return true;
            }
            case 's': {
                out.append(' ');
                return true;
            }
            case '\'': {
                out.append('\'');
                return true;
            }
            case '\"': {
                out.append('\"');
                return true;
            }
            case '\n': {
                return textBlock;
            }
        }
        return false;
    }

    private static int parseOctalEscape(char c2, @NotNull String s2, int index, @NotNull StringBuilder out) {
        if (s2 == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(21);
        }
        if (out == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(22);
        }
        char startC = c2;
        int v2 = c2 - 48;
        if (index < s2.length()) {
            if ('0' <= (c2 = s2.charAt(index++)) && c2 <= '7') {
                v2 <<= 3;
                v2 += c2 - 48;
                if (startC <= '3' && index < s2.length()) {
                    if ('0' <= (c2 = s2.charAt(index++)) && c2 <= '7') {
                        v2 <<= 3;
                        v2 += c2 - 48;
                    } else {
                        --index;
                    }
                }
            } else {
                --index;
            }
        }
        out.append((char)v2);
        return index;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/codeInsight/CodeInsightUtilCore";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementInRange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "forcePsiPostprocessAndRestoreElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "parseStringCharacters";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "noEscape";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "parseStringCharactersWithEscape";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "parseEscapedSymbol";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "parseUnicodeEscape";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "parseEscapedChar";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "parseOctalEscape";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

