/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.gradle.util.GradleVersion;

class HelpModelCompatibilityHelper {
    private HelpModelCompatibilityHelper() {
    }

    static String getRenderedText(String version) {
        String string;
        GradleVersion gradleVersion = GradleVersion.version((String)version);
        String templateVersion = HelpModelCompatibilityHelper.templateVersion(gradleVersion);
        String resourceName = "help-output/gradle-" + templateVersion + ".txt";
        InputStream resourceStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(resourceStream, StandardCharsets.UTF_8));
        try {
            string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("cannot load " + resourceName + " from classloader resource for " + version, e);
            }
        }
        reader.close();
        return string;
    }

    private static String templateVersion(GradleVersion gradleVersion) {
        String[] helpOutputResourceVersion;
        for (String resourceVersion : helpOutputResourceVersion = new String[]{"9.2.0", "9.1.0", "9.0.0", "8.11", "8.3", "8.2", "8.1", "8.0.1", "8.0", "7.6", "7.5", "7.3", "7.1", "7.0", "6.8.1", "6.6", "6.5", "6.2", "6.1", "6.0", "5.0", "4.8", "4.6", "4.5", "4.4", "4.3", "4.0"}) {
            if (gradleVersion.compareTo(GradleVersion.version((String)resourceVersion)) < 0) continue;
            return resourceVersion;
        }
        return "4.0";
    }
}

