/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.internal;

import com.googlecode.jatl.Html;
import java.io.File;
import java.io.Writer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.reporting.Report;
import org.gradle.reporting.HtmlPageBuilder;
import org.gradle.reporting.HtmlReportRenderer;
import org.gradle.reporting.ReportRenderer;
import org.gradle.util.GradleVersion;
import org.gradle.util.internal.RelativePathUtil;

public class BuildDashboardGenerator
extends ReportRenderer<Collection<Report>, File> {
    private Set<Report> reports;
    private File outputFile;

    public void render(Collection<Report> reports, File outputFile) {
        this.reports = new TreeSet<Report>(new Comparator<Report>(){

            @Override
            public int compare(Report o1, Report o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        this.reports.addAll(reports);
        this.outputFile = outputFile;
        HtmlReportRenderer renderer = new HtmlReportRenderer();
        renderer.renderRawSinglePage(reports, (ReportRenderer)new ReportRenderer<Collection<Report>, HtmlPageBuilder<Writer>>(){

            public void render(Collection<Report> model, HtmlPageBuilder<Writer> builder) {
                BuildDashboardGenerator.this.generate((HtmlPageBuilder<Writer>)builder);
            }
        }, outputFile);
    }

    private void generate(final HtmlPageBuilder<Writer> builder) {
        final String baseCssLink = builder.requireResource(((Object)((Object)this)).getClass().getResource("/org/gradle/reporting/base-style.css"));
        final String cssLink = builder.requireResource(((Object)((Object)this)).getClass().getResource("style.css"));
        new Html((Writer)builder.getOutput()){
            {
                super(writer);
                this.html();
                this.head();
                ((Html)((Html)this.meta()).httpEquiv("Content-Type")).content("text/html; charset=utf-8");
                ((Html)((Html)this.meta()).httpEquiv("x-ua-compatible")).content("IE=edge");
                ((Html)((Html)((Html)((Html)this.link()).rel("stylesheet")).type("text/css")).href(baseCssLink)).end();
                ((Html)((Html)((Html)((Html)this.link()).rel("stylesheet")).type("text/css")).href(cssLink)).end();
                ((Html)((Html)this.title()).text("Build dashboard")).end();
                this.end();
                this.body();
                ((Html)this.div()).id("content");
                if (BuildDashboardGenerator.this.reports.size() > 0) {
                    ((Html)((Html)this.h1()).text("Build reports")).end();
                    this.ul();
                    for (Report report : BuildDashboardGenerator.this.reports) {
                        this.li();
                        if (((FileSystemLocation)report.getOutputLocation().get()).getAsFile().exists()) {
                            ((Html)((Html)this.a()).href(RelativePathUtil.relativePath((File)BuildDashboardGenerator.this.outputFile.getParentFile(), (File)BuildDashboardGenerator.this.getHtmlLinkedFileFromReport(report)))).text(report.getDisplayName());
                        } else {
                            ((Html)((Html)this.span()).classAttr("unavailable")).text(report.getDisplayName());
                        }
                        this.end(2);
                    }
                    this.end();
                } else {
                    ((Html)((Html)this.h1()).text("There are no build reports available.")).end();
                }
                ((Html)this.div()).id("footer");
                this.p();
                this.text("Generated by ");
                ((Html)((Html)((Html)this.a()).href("https://www.gradle.org")).text(GradleVersion.current().toString())).end();
                this.text(" at " + builder.formatDate(new Date()));
                this.end();
                this.end();
                this.end();
                this.endAll();
            }
        };
    }

    private File getHtmlLinkedFileFromReport(Report report) {
        if (report instanceof DirectoryReport) {
            return ((DirectoryReport)report).getEntryPoint();
        }
        return ((FileSystemLocation)report.getOutputLocation().get()).getAsFile();
    }
}

