/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.collect;

import java.util.Arrays;

final class ArrayCopy {
    static final Object[] EMPTY_ARRAY = new Object[0];

    ArrayCopy() {
    }

    static Object[] append(Object[] array, Object newElement) {
        Object[] newArray = new Object[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = newElement;
        return newArray;
    }

    static Object[] append(Object[] array, Object e1, Object e2) {
        int length = array.length;
        Object[] newArray = new Object[length + 2];
        System.arraycopy(array, 0, newArray, 0, length);
        newArray[length] = e1;
        newArray[length + 1] = e2;
        return newArray;
    }

    static Object[] replaceAt(int index, Object[] array, Object newElement) {
        Object[] newArray = (Object[])array.clone();
        newArray[index] = newElement;
        return newArray;
    }

    static Object[] insertAt(int index, Object[] array, Object newElement) {
        Object[] newArray = new Object[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(array, index, newArray, index + 1, array.length - index);
        newArray[index] = newElement;
        return newArray;
    }

    static Object[] insertAt(int index, Object[] array, Object e1, Object e2) {
        Object[] newArray = new Object[array.length + 2];
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(array, index, newArray, index + 2, array.length - index);
        newArray[index] = e1;
        newArray[index + 1] = e2;
        return newArray;
    }

    static Object[] insertAtPushingLeft(int index, Object[] array, Object newElement, int leftIndexToOverwrite, int payload) {
        assert (index >= leftIndexToOverwrite);
        assert (payload == 0 || payload == 1);
        if (payload == 0) {
            Object[] newArray = (Object[])array.clone();
            System.arraycopy(array, leftIndexToOverwrite + 1, newArray, leftIndexToOverwrite, index - leftIndexToOverwrite);
            newArray[index] = newElement;
            return newArray;
        }
        int length = array.length;
        Object[] newArray = Arrays.copyOf(array, length - 1);
        int middleLen = index - leftIndexToOverwrite - 1;
        System.arraycopy(array, leftIndexToOverwrite + 2, newArray, leftIndexToOverwrite, middleLen);
        int tailLen = length - index - 1;
        System.arraycopy(array, index + 1, newArray, index, tailLen);
        newArray[index - 1] = newElement;
        return newArray;
    }

    static Object[] insertAtPushingRight(int index, Object[] original, Object[] dataSrc, int dataSrcIndex, int dataLength, int rightIndexToOverwrite) {
        assert (index <= rightIndexToOverwrite);
        assert (dataLength >= 0);
        assert (dataSrcIndex >= 0 && dataSrcIndex + dataLength <= dataSrc.length);
        int originalLength = original.length;
        int newLength = originalLength + dataLength - 1;
        Object[] newArray = new Object[newLength];
        System.arraycopy(original, 0, newArray, 0, index);
        System.arraycopy(dataSrc, dataSrcIndex, newArray, index, dataLength);
        int middleLen = rightIndexToOverwrite - index;
        System.arraycopy(original, index, newArray, index + dataLength, middleLen);
        int tailSrcPos = rightIndexToOverwrite + 1;
        int tailLen = originalLength - tailSrcPos;
        int tailDestPos = rightIndexToOverwrite + dataLength;
        System.arraycopy(original, tailSrcPos, newArray, tailDestPos, tailLen);
        return newArray;
    }

    static Object[] insertAtPushingRight(int index, Object[] array, Object newElement, int rightIndexToOverwrite) {
        assert (index <= rightIndexToOverwrite);
        Object[] newArray = (Object[])array.clone();
        int len = rightIndexToOverwrite - index;
        System.arraycopy(array, index, newArray, index + 1, len);
        newArray[index] = newElement;
        return newArray;
    }

    static Object[] removeAt(int index, Object[] array, int count) {
        int newLen = array.length - count;
        Object[] newArray = new Object[newLen];
        System.arraycopy(array, 0, newArray, 0, index);
        int tailLen = newLen - index;
        System.arraycopy(array, index + count, newArray, index, tailLen);
        return newArray;
    }
}

