/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.capabilities.MutableCapabilitiesMetadata;
import org.gradle.api.internal.capabilities.ImmutableCapability;
import org.gradle.internal.component.external.model.DefaultCapabilitiesMetadata;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.component.external.model.ImmutableCapabilities;

public class DefaultMutableCapabilitiesMetadata
implements MutableCapabilitiesMetadata {
    private final Set<ImmutableCapability> descriptors;

    public DefaultMutableCapabilitiesMetadata(ImmutableCapabilities capabilities) {
        this.descriptors = new LinkedHashSet<ImmutableCapability>((Collection<ImmutableCapability>)capabilities.asSet());
    }

    public void addCapability(String group, String name, String version) {
        for (Capability capability : this.descriptors) {
            if (!capability.getGroup().equals(group) || !capability.getName().equals(name) || capability.getVersion().equals(version)) continue;
            throw new InvalidUserDataException("Cannot add capability " + group + ":" + name + " with version " + version + " because it's already defined with version " + capability.getVersion());
        }
        this.descriptors.add(new DefaultImmutableCapability(group, name, version));
    }

    public void removeCapability(String group, String name) {
        this.descriptors.removeIf(next -> next.getGroup().equals(group) && next.getName().equals(name));
    }

    public CapabilitiesMetadata asImmutable() {
        return new DefaultCapabilitiesMetadata(this.asImmutableCapabilities());
    }

    public ImmutableList<? extends Capability> getCapabilities() {
        return ImmutableList.copyOf(this.descriptors);
    }

    public ImmutableCapabilities asImmutableCapabilities() {
        return new ImmutableCapabilities((ImmutableSet<ImmutableCapability>)ImmutableSet.copyOf(this.descriptors));
    }
}

