/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.flow.services;

import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.flow.FlowAction;
import org.gradle.api.flow.FlowParameters;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.flow.services.RegisteredFlowAction;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.service.CloseableServiceRegistry;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistrationAction;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.process.ExecOperations;
import org.jetbrains.annotations.NotNull;

@ServiceScope(value={Scope.Build.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0016\u0010\u0015\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/gradle/internal/flow/services/FlowScheduler;", "", "instantiatorFactory", "Lorg/gradle/internal/instantiation/InstantiatorFactory;", "serviceRegistry", "Lorg/gradle/internal/service/ServiceRegistry;", "buildState", "Lorg/gradle/internal/build/BuildState;", "<init>", "(Lorg/gradle/internal/instantiation/InstantiatorFactory;Lorg/gradle/internal/service/ServiceRegistry;Lorg/gradle/internal/build/BuildState;)V", "instantiator", "Lorg/gradle/internal/instantiation/InstanceGenerator;", "getInstantiator", "()Lorg/gradle/internal/instantiation/InstanceGenerator;", "instantiator$delegate", "Lkotlin/Lazy;", "schedule", "", "scheduled", "", "Lorg/gradle/internal/flow/services/RegisteredFlowAction;", "runActions", "injectableServicesOf", "flow-services"})
@SourceDebugExtension(value={"SMAP\nFlowScheduler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlowScheduler.kt\norg/gradle/internal/flow/services/FlowScheduler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1915#2,2:83\n*S KotlinDebug\n*F\n+ 1 FlowScheduler.kt\norg/gradle/internal/flow/services/FlowScheduler\n*L\n63#1:83,2\n*E\n"})
public final class FlowScheduler {
    @NotNull
    private final BuildState buildState;
    @NotNull
    private final Lazy instantiator$delegate;

    public FlowScheduler(@NotNull InstantiatorFactory instantiatorFactory, @NotNull ServiceRegistry serviceRegistry, @NotNull BuildState buildState) {
        Intrinsics.checkNotNullParameter((Object)instantiatorFactory, (String)"instantiatorFactory");
        Intrinsics.checkNotNullParameter((Object)serviceRegistry, (String)"serviceRegistry");
        Intrinsics.checkNotNullParameter((Object)buildState, (String)"buildState");
        this.buildState = buildState;
        this.instantiator$delegate = LazyKt.lazy(() -> FlowScheduler.instantiator_delegate$lambda$0(instantiatorFactory, this, serviceRegistry));
    }

    private final InstanceGenerator getInstantiator() {
        Lazy lazy = this.instantiator$delegate;
        return (InstanceGenerator)lazy.getValue();
    }

    public final void schedule(@NotNull List<RegisteredFlowAction> scheduled) {
        Intrinsics.checkNotNullParameter(scheduled, (String)"scheduled");
        if (this.buildState.isProjectsLoaded()) {
            this.buildState.getProjects().withMutableStateOfAllProjects(new Runnable(this, scheduled){
                final /* synthetic */ FlowScheduler this$0;
                final /* synthetic */ List<RegisteredFlowAction> $scheduled;
                {
                    this.this$0 = $receiver;
                    this.$scheduled = $scheduled;
                }

                public final void run() {
                    FlowScheduler.access$runActions(this.this$0, this.$scheduled);
                }
            });
        } else {
            this.runActions(scheduled);
        }
    }

    private final void runActions(List<RegisteredFlowAction> scheduled) {
        Iterable $this$forEach$iv = scheduled;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RegisteredFlowAction flowAction = (RegisteredFlowAction)element$iv;
            boolean bl = false;
            FlowAction flowAction2 = (FlowAction)this.getInstantiator().newInstance(flowAction.getType(), new Object[0]);
            FlowParameters flowParameters = flowAction.getParameters();
            if (flowParameters == null) {
                FlowParameters.None none = FlowParameters.None.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)none, (String)"INSTANCE");
                flowParameters = (FlowParameters)none;
            }
            flowAction2.execute(flowParameters);
        }
    }

    private final ServiceRegistry injectableServicesOf(ServiceRegistry serviceRegistry) {
        CloseableServiceRegistry closeableServiceRegistry = ServiceRegistryBuilder.builder().displayName("flow services").provider(new ServiceRegistrationAction(serviceRegistry){
            final /* synthetic */ ServiceRegistry $serviceRegistry;
            {
                this.$serviceRegistry = $serviceRegistry;
            }

            public final void registerServices(ServiceRegistration registration) {
                Intrinsics.checkNotNullParameter((Object)registration, (String)"registration");
                registration.add(ArchiveOperations.class, this.$serviceRegistry.get(ArchiveOperations.class));
                registration.add(ExecOperations.class, this.$serviceRegistry.get(ExecOperations.class));
                registration.add(FileSystemOperations.class, this.$serviceRegistry.get(FileSystemOperations.class));
            }
        }).build();
        Intrinsics.checkNotNullExpressionValue((Object)closeableServiceRegistry, (String)"build(...)");
        return (ServiceRegistry)closeableServiceRegistry;
    }

    private static final InstanceGenerator instantiator_delegate$lambda$0(InstantiatorFactory $instantiatorFactory, FlowScheduler this$0, ServiceRegistry $serviceRegistry) {
        return $instantiatorFactory.injectScheme().withServices((ServiceLookup)this$0.injectableServicesOf($serviceRegistry)).instantiator();
    }

    public static final /* synthetic */ void access$runActions(FlowScheduler $this, List scheduled) {
        $this.runActions(scheduled);
    }
}

