/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories;

import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.DelegatingExcludeFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.ExcludeFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.Intersections;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.Optimizations;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.Unions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.CompositeExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeAllOf;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeAnyOf;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeEverything;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeNothing;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.GroupExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.GroupSetExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ModuleExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ModuleIdExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ModuleIdSetExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ModuleSetExclude;
import org.gradle.internal.Cast;
import org.gradle.internal.collect.PersistentMap;
import org.gradle.internal.collect.PersistentSet;

public class NormalizingExcludeFactory
extends DelegatingExcludeFactory {
    private final Intersections intersections = new Intersections(this);
    private final Unions unions = new Unions(this);

    public NormalizingExcludeFactory(ExcludeFactory delegate) {
        super(delegate);
    }

    @Override
    public ExcludeSpec anyOf(ExcludeSpec one, ExcludeSpec two) {
        return NormalizingExcludeFactory.simplify(ExcludeAllOf.class, one, two, (left, right) -> this.doUnion((PersistentSet<ExcludeSpec>)PersistentSet.of((Object[])new ExcludeSpec[]{left, right})));
    }

    @Override
    public ExcludeSpec allOf(ExcludeSpec one, ExcludeSpec two) {
        return NormalizingExcludeFactory.simplify(ExcludeAnyOf.class, one, two, (left, right) -> this.doIntersect((PersistentSet<ExcludeSpec>)PersistentSet.of((Object[])new ExcludeSpec[]{left, right})));
    }

    private static ExcludeSpec simplify(Class<? extends CompositeExclude> clazz, ExcludeSpec one, ExcludeSpec two, BiFunction<ExcludeSpec, ExcludeSpec, ExcludeSpec> orElse) {
        if (clazz.isInstance(one) && NormalizingExcludeFactory.componentsOf(one).contains((Object)two)) {
            return two;
        }
        if (clazz.isInstance(two) && NormalizingExcludeFactory.componentsOf(two).contains((Object)one)) {
            return one;
        }
        return orElse.apply(one, two);
    }

    private static PersistentSet<ExcludeSpec> simplifySet(Class<? extends CompositeExclude> clazz, PersistentSet<ExcludeSpec> specs) {
        return specs.filter(left -> !clazz.isInstance(left) || specs.noneMatch(right -> NormalizingExcludeFactory.componentsOf(left).contains(right)));
    }

    private static PersistentSet<ExcludeSpec> componentsOf(ExcludeSpec spec) {
        return ((CompositeExclude)spec).getComponents();
    }

    @Override
    public ExcludeSpec anyOf(PersistentSet<ExcludeSpec> specs) {
        return this.doUnion(specs);
    }

    @Override
    public ExcludeSpec allOf(PersistentSet<ExcludeSpec> specs) {
        return this.doIntersect(specs);
    }

    private ExcludeSpec doUnion(PersistentSet<ExcludeSpec> specs) {
        ExcludeSpec excludeSpec;
        specs = NormalizingExcludeFactory.simplifySet(ExcludeAllOf.class, specs);
        FlattenOperationResult flattened = NormalizingExcludeFactory.flatten(ExcludeAnyOf.class, specs, ExcludeEverything.class::isInstance, ExcludeNothing.class::isInstance);
        if (flattened.fastExit) {
            return this.everything();
        }
        if (flattened.result.isEmpty()) {
            return this.nothing();
        }
        PersistentMap byType = flattened.result.groupBy(UnionOf::typeOf);
        PersistentSet moduleIdExcludes = UnionOf.MODULE_ID.fromMap((PersistentMap<UnionOf, PersistentSet<ExcludeSpec>>)byType);
        PersistentSet moduleIdSetsExcludes = UnionOf.MODULE_ID_SET.fromMap((PersistentMap<UnionOf, PersistentSet<ExcludeSpec>>)byType);
        PersistentSet groupExcludes = UnionOf.GROUP.fromMap((PersistentMap<UnionOf, PersistentSet<ExcludeSpec>>)byType);
        PersistentSet groupSetExcludes = UnionOf.GROUP_SET.fromMap((PersistentMap<UnionOf, PersistentSet<ExcludeSpec>>)byType);
        PersistentSet moduleExcludes = UnionOf.MODULE.fromMap((PersistentMap<UnionOf, PersistentSet<ExcludeSpec>>)byType);
        PersistentSet moduleSetExcludes = UnionOf.MODULE_SET.fromMap((PersistentMap<UnionOf, PersistentSet<ExcludeSpec>>)byType);
        PersistentSet other = UnionOf.NOT_JOINABLE.fromMap((PersistentMap<UnionOf, PersistentSet<ExcludeSpec>>)byType);
        if (!(moduleIdExcludes.isEmpty() || moduleIdExcludes.size() <= 1 && moduleIdSetsExcludes.isEmpty())) {
            excludeSpec = this.delegate.moduleIdSet((PersistentSet<ModuleIdentifier>)moduleIdExcludes.map(ModuleIdExclude::getModuleId));
            moduleIdSetsExcludes = moduleIdSetsExcludes.isEmpty() ? PersistentSet.of((Object)excludeSpec) : moduleIdSetsExcludes.plus((Object)excludeSpec);
            moduleIdExcludes = PersistentSet.of();
        }
        if (!(groupExcludes.isEmpty() || groupExcludes.size() <= 1 && groupSetExcludes.isEmpty())) {
            excludeSpec = this.delegate.groupSet((PersistentSet<String>)groupExcludes.map(GroupExclude::getGroup));
            groupSetExcludes = groupSetExcludes.isEmpty() ? PersistentSet.of((Object)excludeSpec) : groupSetExcludes.plus((Object)excludeSpec);
            groupExcludes = PersistentSet.of();
        }
        if (!(moduleExcludes.isEmpty() || moduleExcludes.size() <= 1 && moduleSetExcludes.isEmpty())) {
            excludeSpec = this.delegate.moduleSet((PersistentSet<String>)moduleExcludes.map(ModuleExclude::getModule));
            moduleSetExcludes = moduleSetExcludes.isEmpty() ? PersistentSet.of((Object)excludeSpec) : moduleSetExcludes.plus((Object)excludeSpec);
            moduleExcludes = PersistentSet.of();
        }
        if (moduleIdSetsExcludes.size() > 1) {
            moduleIdSetsExcludes = PersistentSet.of((Object)this.delegate.moduleIdSet((PersistentSet<ModuleIdentifier>)moduleIdSetsExcludes.flatMap(ModuleIdSetExclude::getModuleIds)));
        }
        if (groupSetExcludes.size() > 1) {
            groupSetExcludes = PersistentSet.of((Object)this.delegate.groupSet((PersistentSet<String>)groupSetExcludes.flatMap(GroupSetExclude::getGroups)));
        }
        if (moduleSetExcludes.size() > 1) {
            moduleSetExcludes = PersistentSet.of((Object)this.delegate.moduleSet((PersistentSet<String>)moduleSetExcludes.flatMap(ModuleSetExclude::getModules)));
        }
        PersistentSet<ExcludeSpec> elements = PersistentSet.of().union(moduleIdExcludes).union(groupExcludes).union(moduleExcludes).union(moduleIdSetsExcludes).union(groupSetExcludes).union(moduleSetExcludes).union(other);
        elements = NormalizingExcludeFactory.fixedPointOf(this::simplifyUnion, elements);
        return Optimizations.optimizeCollection(this, elements, this.delegate::anyOf);
    }

    private static PersistentSet<ExcludeSpec> fixedPointOf(Simplification function, PersistentSet<ExcludeSpec> specs) {
        PersistentSet<ExcludeSpec> simplified;
        PersistentSet<ExcludeSpec> current = specs;
        while (current.size() > 1 && (simplified = NormalizingExcludeFactory.simplifyOnce(function, current)) != current) {
            current = simplified;
        }
        return current;
    }

    private static PersistentSet<ExcludeSpec> simplifyOnce(Simplification function, PersistentSet<ExcludeSpec> specs) {
        for (ExcludeSpec left : specs) {
            for (ExcludeSpec right : specs) {
                PersistentSet<ExcludeSpec> simplified;
                if (left == right || (simplified = function.apply(left, right, specs)) == specs) continue;
                return simplified;
            }
        }
        return specs;
    }

    private PersistentSet<ExcludeSpec> simplifyUnion(ExcludeSpec left, ExcludeSpec right, PersistentSet<ExcludeSpec> specs) {
        ExcludeSpec merged = this.unions.tryUnion(left, right);
        if (merged != null) {
            if (merged instanceof ExcludeEverything) {
                return PersistentSet.of((Object)merged);
            }
            PersistentSet simplified = specs.minus((Object)left).minus((Object)right);
            if (merged instanceof ExcludeAnyOf) {
                return simplified.union(((ExcludeAnyOf)merged).getComponents());
            }
            return simplified.plus((Object)merged);
        }
        return specs;
    }

    private static <T extends ExcludeSpec> FlattenOperationResult flatten(Class<T> flattenType, PersistentSet<ExcludeSpec> specs, Predicate<ExcludeSpec> fastExit, Predicate<ExcludeSpec> ignoreSpec) {
        boolean filtered = false;
        boolean flatten = false;
        for (ExcludeSpec spec : specs) {
            if (fastExit.test(spec)) {
                return FlattenOperationResult.FAST_EXIT;
            }
            if (ignoreSpec.test(spec)) {
                filtered = true;
                continue;
            }
            if (!flattenType.isInstance(spec)) continue;
            flatten = true;
        }
        if (!filtered && !flatten) {
            return FlattenOperationResult.of(specs);
        }
        if (filtered && !flatten) {
            return NormalizingExcludeFactory.filterOnly(specs, ignoreSpec);
        }
        return NormalizingExcludeFactory.expensiveFlatten(flattenType, NormalizingExcludeFactory.maybeFilter(specs, ignoreSpec, filtered));
    }

    private static FlattenOperationResult filterOnly(PersistentSet<ExcludeSpec> specs, Predicate<ExcludeSpec> ignoreSpec) {
        return FlattenOperationResult.of((PersistentSet<ExcludeSpec>)specs.filter(e -> !ignoreSpec.test((ExcludeSpec)e)));
    }

    private static PersistentSet<ExcludeSpec> maybeFilter(PersistentSet<ExcludeSpec> specs, Predicate<ExcludeSpec> ignoreSpec, boolean filtered) {
        PersistentSet stream = specs;
        if (filtered) {
            stream = stream.filter(e -> !ignoreSpec.test((ExcludeSpec)e));
        }
        return stream;
    }

    private static <T extends ExcludeSpec> FlattenOperationResult expensiveFlatten(Class<T> flattenType, PersistentSet<ExcludeSpec> specs) {
        return FlattenOperationResult.of((PersistentSet<ExcludeSpec>)specs.flatMap(e -> {
            if (flattenType.isInstance(e)) {
                CompositeExclude compositeExclude = (CompositeExclude)e;
                return compositeExclude.getComponents();
            }
            return PersistentSet.of((Object)e);
        }));
    }

    private ExcludeSpec doIntersect(PersistentSet<ExcludeSpec> specs) {
        specs = NormalizingExcludeFactory.simplifySet(ExcludeAnyOf.class, specs);
        FlattenOperationResult flattened = NormalizingExcludeFactory.flatten(ExcludeAllOf.class, specs, ExcludeNothing.class::isInstance, ExcludeEverything.class::isInstance);
        if (flattened.fastExit) {
            return this.nothing();
        }
        PersistentSet<ExcludeSpec> result = flattened.result;
        if (result.isEmpty()) {
            return this.everything();
        }
        result = NormalizingExcludeFactory.fixedPointOf(this::simplifyIntersect, result);
        return Optimizations.optimizeCollection(this, result, this.delegate::allOf);
    }

    private PersistentSet<ExcludeSpec> simplifyIntersect(ExcludeSpec left, ExcludeSpec right, PersistentSet<ExcludeSpec> specs) {
        ExcludeSpec merged = this.intersections.tryIntersect(left, right);
        if (merged != null) {
            if (merged instanceof ExcludeNothing) {
                return PersistentSet.of((Object)merged);
            }
            return specs.minus((Object)left).minus((Object)right).plus((Object)merged);
        }
        return specs;
    }

    private static class FlattenOperationResult {
        private static final FlattenOperationResult FAST_EXIT = new FlattenOperationResult(null, true);
        private final PersistentSet<ExcludeSpec> result;
        private final boolean fastExit;

        private FlattenOperationResult(PersistentSet<ExcludeSpec> result, boolean fastExit) {
            this.result = result;
            this.fastExit = fastExit;
        }

        public static FlattenOperationResult of(PersistentSet<ExcludeSpec> specs) {
            return new FlattenOperationResult(specs, false);
        }
    }

    private static enum UnionOf {
        MODULE_ID(ModuleIdExclude.class),
        GROUP(GroupExclude.class),
        MODULE(ModuleExclude.class),
        MODULE_ID_SET(ModuleIdSetExclude.class),
        GROUP_SET(GroupSetExclude.class),
        MODULE_SET(ModuleSetExclude.class),
        NOT_JOINABLE(ExcludeSpec.class);

        private final Class<? extends ExcludeSpec> excludeClass;

        private UnionOf(Class<? extends ExcludeSpec> excludeClass) {
            this.excludeClass = excludeClass;
        }

        public <T extends ExcludeSpec> PersistentSet<T> fromMap(PersistentMap<UnionOf, PersistentSet<ExcludeSpec>> from) {
            return (PersistentSet)Cast.uncheckedCast((Object)from.getOrDefault((Object)this, (Object)PersistentSet.of()));
        }

        public static UnionOf typeOf(ExcludeSpec spec) {
            for (UnionOf unionOf : UnionOf.values()) {
                if (!unionOf.excludeClass.isInstance(spec)) continue;
                return unionOf;
            }
            return null;
        }
    }

    @FunctionalInterface
    static interface Simplification {
        public PersistentSet<ExcludeSpec> apply(ExcludeSpec var1, ExcludeSpec var2, PersistentSet<ExcludeSpec> var3);
    }
}

