/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.workspace;

import java.io.File;
import java.util.function.Supplier;

public interface ImmutableWorkspaceProvider {
    public ImmutableWorkspace getWorkspace(String var1);

    public static class ConcurrentResult<T> {
        private final T value;
        private final boolean isProducedByCurrentThread;

        private ConcurrentResult(T value, boolean isProducedByCurrentThread) {
            this.value = value;
            this.isProducedByCurrentThread = isProducedByCurrentThread;
        }

        public T get() {
            return this.value;
        }

        public boolean isProducedByCurrentThread() {
            return this.isProducedByCurrentThread;
        }

        public static <T> ConcurrentResult<T> producedByCurrentThread(T value) {
            return new ConcurrentResult<T>(value, true);
        }

        public static <T> ConcurrentResult<T> producedByOtherThread(T value) {
            return new ConcurrentResult<T>(value, false);
        }
    }

    public static interface ImmutableWorkspace {
        public File getImmutableLocation();

        public <T> T withFileLock(Supplier<T> var1);

        public <T> ConcurrentResult<T> getOrCompute(Supplier<T> var1);

        public boolean isSoftDeleted();

        public void ensureUnSoftDeleted();
    }
}

