/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.GroovySystem;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.control.messages.ExceptionMessage;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.tools.javac.JavaAwareCompilationUnit;
import org.codehaus.groovy.tools.javac.JavaCompiler;
import org.codehaus.groovy.tools.javac.JavaCompilerFactory;
import org.gradle.api.GradleException;
import org.gradle.api.internal.tasks.compile.ApiCompilerResult;
import org.gradle.api.internal.tasks.compile.CompilationClassBackupService;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.internal.tasks.compile.CompilationFatalException;
import org.gradle.api.internal.tasks.compile.CompilationSourceDirs;
import org.gradle.api.internal.tasks.compile.GroovyCompileTransformingClassLoader;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.FileUtils;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classloader.DefaultClassLoaderFactory;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.groovyloader.GroovySystemLoader;
import org.gradle.internal.groovyloader.GroovySystemLoaderFactory;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.util.internal.VersionNumber;

public class ApiGroovyCompiler
implements Compiler<GroovyJavaJointCompileSpec>,
Serializable {
    private final Compiler<JavaCompileSpec> javaCompiler;
    private final ObjectFactory objectFactory;

    public ApiGroovyCompiler(Compiler<JavaCompileSpec> javaCompiler, ObjectFactory objectFactory) {
        this.javaCompiler = javaCompiler;
        this.objectFactory = objectFactory;
    }

    private File[] getSortedSourceFiles(GroovyJavaJointCompileSpec spec) {
        Object[] sortedSourceFiles = (File[])Iterables.toArray((Iterable)spec.getSourceFiles(), File.class);
        Arrays.sort(sortedSourceFiles);
        return sortedSourceFiles;
    }

    public WorkResult execute(final GroovyJavaJointCompileSpec spec) {
        ApiCompilerResult apiCompilerResult;
        final ApiCompilerResult result = new ApiCompilerResult();
        result.getAnnotationProcessingResult().setFullRebuildCause("Incremental annotation processing is not supported by Groovy.");
        GroovySystemLoaderFactory groovySystemLoaderFactory = new GroovySystemLoaderFactory();
        ClassLoader compilerClassLoader = this.getClass().getClassLoader();
        GroovySystemLoader compilerGroovyLoader = groovySystemLoaderFactory.forClassLoader(compilerClassLoader);
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.setVerbose(spec.getGroovyCompileOptions().isVerbose());
        configuration.setSourceEncoding(spec.getGroovyCompileOptions().getEncoding());
        configuration.setTargetBytecode(spec.getTargetCompatibility());
        configuration.setTargetDirectory(spec.getDestinationDir());
        ApiGroovyCompiler.canonicalizeValues(spec.getGroovyCompileOptions().getOptimizationOptions());
        VersionNumber version = this.parseGroovyVersion();
        if (version.compareTo(VersionNumber.parse((String)"2.5")) >= 0) {
            configuration.setParameters(spec.getGroovyCompileOptions().isParameters());
        } else if (spec.getGroovyCompileOptions().isParameters()) {
            throw new GradleException("Using Groovy compiler flag '--parameters' requires Groovy 2.5+ but found Groovy " + version);
        }
        IncrementalCompilationCustomizer customizer = IncrementalCompilationCustomizer.fromSpec(spec, result);
        customizer.addToConfiguration(configuration);
        if (spec.getGroovyCompileOptions().getConfigurationScript() != null) {
            this.applyConfigurationScript(spec.getGroovyCompileOptions().getConfigurationScript(), configuration);
        }
        try {
            configuration.setOptimizationOptions(spec.getGroovyCompileOptions().getOptimizationOptions());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            configuration.setDisabledGlobalASTTransformations(spec.getGroovyCompileOptions().getDisabledGlobalASTTransformations());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        HashMap<String, Comparable<File>> jointCompilationOptions = new HashMap<String, Comparable<File>>();
        final File stubDir = spec.getGroovyCompileOptions().getStubDir();
        stubDir.mkdirs();
        jointCompilationOptions.put("stubDir", stubDir);
        jointCompilationOptions.put("keepStubs", Boolean.valueOf(spec.getGroovyCompileOptions().isKeepStubs()));
        configuration.setJointCompilationOptions(jointCompilationOptions);
        Object classPathLoader = version.compareTo(VersionNumber.parse((String)"2.0")) < 0 ? new GroovyCompileTransformingClassLoader(this.getExtClassLoader(), DefaultClassPath.of((Collection)spec.getCompileClasspath())) : new DefaultClassLoaderFactory().createIsolatedClassLoader("api-groovy-compile-loader", DefaultClassPath.of((Collection)spec.getCompileClasspath()));
        GroovyClassLoader compileClasspathClassLoader = new GroovyClassLoader((ClassLoader)classPathLoader, null);
        GroovySystemLoader compileClasspathLoader = groovySystemLoaderFactory.forClassLoader((ClassLoader)classPathLoader);
        FilteringClassLoader.Spec groovyCompilerClassLoaderSpec = new FilteringClassLoader.Spec();
        groovyCompilerClassLoaderSpec.allowPackage("org.codehaus.groovy");
        groovyCompilerClassLoaderSpec.allowPackage("groovy");
        groovyCompilerClassLoaderSpec.allowPackage("groovyjarjarasm");
        groovyCompilerClassLoaderSpec.disallowClass("groovy.util.GroovyTestCase");
        groovyCompilerClassLoaderSpec.disallowClass("groovy.test.GroovyTestCase");
        groovyCompilerClassLoaderSpec.disallowClass("org.codehaus.groovy.transform.NotYetImplementedASTTransformation");
        groovyCompilerClassLoaderSpec.disallowPackage("groovy.servlet");
        FilteringClassLoader groovyCompilerClassLoader = new FilteringClassLoader(GroovyClassLoader.class.getClassLoader(), groovyCompilerClassLoaderSpec);
        final GroovyClassLoader astTransformClassLoader = new GroovyClassLoader((ClassLoader)groovyCompilerClassLoader, null);
        for (File file : spec.getCompileClasspath()) {
            astTransformClassLoader.addClasspath(file.getPath());
        }
        JavaAwareCompilationUnit unit = new JavaAwareCompilationUnit(configuration, compileClasspathClassLoader){

            public GroovyClassLoader getTransformLoader() {
                return astTransformClassLoader;
            }
        };
        final boolean shouldProcessAnnotations = ApiGroovyCompiler.shouldProcessAnnotations(spec);
        if (shouldProcessAnnotations) {
            unit.addSources(new File[]{new File("ForceStubGeneration.java")});
        }
        unit.addSources(this.getSortedSourceFiles(spec));
        unit.setCompilerFactory(new JavaCompilerFactory(){

            public JavaCompiler createCompiler(CompilerConfiguration config) {
                return new JavaCompiler(){

                    public void compile(List<String> files, CompilationUnit cu) {
                        if (shouldProcessAnnotations) {
                            spec.setSourceFiles(Iterables.concat((Iterable)spec.getSourceFiles(), (Iterable)ApiGroovyCompiler.this.objectFactory.fileTree().from((Object)stubDir)));
                        } else {
                            ImmutableList.Builder sourcepathBuilder = ImmutableList.builder();
                            sourcepathBuilder.add((Object)stubDir);
                            if (spec.getCompileOptions().getSourcepath() != null) {
                                sourcepathBuilder.addAll((Iterable)spec.getCompileOptions().getSourcepath());
                            }
                            spec.getCompileOptions().setSourcepath((List)sourcepathBuilder.build());
                        }
                        spec.setSourceFiles(Iterables.filter((Iterable)spec.getSourceFiles(), (Predicate)new Predicate<File>(){

                            public boolean apply(File file) {
                                return FileUtils.hasExtension((File)file, (String)".java");
                            }
                        }));
                        try {
                            WorkResult javaCompilerResult = ApiGroovyCompiler.this.javaCompiler.execute((CompileSpec)spec);
                            if (javaCompilerResult instanceof ApiCompilerResult) {
                                this.copyJavaCompilerResult((ApiCompilerResult)javaCompilerResult);
                            }
                        }
                        catch (CompilationFailedException e) {
                            Optional partialResult = e.getCompilerPartialResult();
                            partialResult.ifPresent(result -> this.copyJavaCompilerResult(result));
                            cu.getErrorCollector().addFatalError((Message)new SimpleMessage(e.getMessage(), (ProcessingUnit)cu));
                        }
                    }
                };
            }

            private void copyJavaCompilerResult(ApiCompilerResult javaCompilerResult) {
                result.getSourceClassesMapping().putAll(javaCompilerResult.getSourceClassesMapping());
                result.getBackupClassFiles().putAll(javaCompilerResult.getBackupClassFiles());
            }
        });
        try {
            unit.compile();
            apiCompilerResult = result;
        }
        catch (org.codehaus.groovy.control.CompilationFailedException e) {
            try {
                if (ApiGroovyCompiler.isFatalException(e)) {
                    throw new CompilationFatalException(e);
                }
                System.err.println(e.getMessage());
                System.err.flush();
                throw new CompilationFailedException(result);
            }
            catch (Throwable throwable) {
                compilerGroovyLoader.discardTypesFrom((ClassLoader)classPathLoader);
                compilerGroovyLoader.discardTypesFrom((ClassLoader)astTransformClassLoader);
                compileClasspathLoader.shutdown();
                CompositeStoppable.stoppable((Object[])new Object[]{classPathLoader, astTransformClassLoader}).stop();
                throw throwable;
            }
        }
        compilerGroovyLoader.discardTypesFrom((ClassLoader)classPathLoader);
        compilerGroovyLoader.discardTypesFrom((ClassLoader)astTransformClassLoader);
        compileClasspathLoader.shutdown();
        CompositeStoppable.stoppable((Object[])new Object[]{classPathLoader, astTransformClassLoader}).stop();
        return apiCompilerResult;
    }

    private static boolean isFatalException(org.codehaus.groovy.control.CompilationFailedException e) {
        if (e instanceof MultipleCompilationErrorsException) {
            return ((MultipleCompilationErrorsException)e).getErrorCollector().getErrors().stream().anyMatch(message -> message instanceof ExceptionMessage);
        }
        return false;
    }

    private static boolean shouldProcessAnnotations(GroovyJavaJointCompileSpec spec) {
        return spec.getGroovyCompileOptions().isJavaAnnotationProcessing() && spec.annotationProcessingConfigured();
    }

    private void applyConfigurationScript(File configScript, CompilerConfiguration configuration) {
        VersionNumber version = this.parseGroovyVersion();
        if (version.compareTo(VersionNumber.parse((String)"2.1")) < 0) {
            throw new GradleException("Using a Groovy compiler configuration script requires Groovy 2.1+ but found Groovy " + version + "");
        }
        Binding binding = new Binding();
        binding.setVariable("configuration", (Object)configuration);
        CompilerConfiguration configuratorConfig = new CompilerConfiguration();
        ImportCustomizer customizer = new ImportCustomizer();
        customizer.addStaticStars(new String[]{"org.codehaus.groovy.control.customizers.builder.CompilerCustomizationBuilder"});
        configuratorConfig.addCompilationCustomizers(new CompilationCustomizer[]{customizer});
        GroovyShell shell = new GroovyShell(binding, configuratorConfig);
        try {
            shell.evaluate(configScript);
        }
        catch (Exception e) {
            throw new GradleException("Could not execute Groovy compiler configuration script: " + configScript.getAbsolutePath(), (Throwable)e);
        }
    }

    private VersionNumber parseGroovyVersion() {
        String version;
        try {
            version = GroovySystem.getVersion();
        }
        catch (NoSuchMethodError e) {
            try {
                Class<?> ih = Class.forName("org.codehaus.groovy.runtime.InvokerHelper");
                Method getVersion = ih.getDeclaredMethod("getVersion", new Class[0]);
                version = (String)getVersion.invoke(ih, new Object[0]);
            }
            catch (Exception e1) {
                throw new GradleException("Unable to determine Groovy version.", (Throwable)e1);
            }
        }
        return VersionNumber.parse((String)version);
    }

    private static void canonicalizeValues(Map<String, Boolean> options) {
        options.replaceAll((k, v) -> v != false ? Boolean.TRUE : Boolean.FALSE);
    }

    private ClassLoader getExtClassLoader() {
        return ClassLoaderUtils.getPlatformClassLoader();
    }

    private static abstract class IncrementalCompilationCustomizer
    extends CompilationCustomizer {
        static IncrementalCompilationCustomizer fromSpec(GroovyJavaJointCompileSpec spec, ApiCompilerResult result) {
            if (spec.incrementalCompilationEnabled()) {
                return new TrackingClassGenerationCompilationCustomizer(new CompilationSourceDirs((JavaCompileSpec)spec), result, new CompilationClassBackupService((JavaCompileSpec)spec, result));
            }
            return new NoOpCompilationCustomizer();
        }

        public IncrementalCompilationCustomizer() {
            super(CompilePhase.CLASS_GENERATION);
        }

        abstract void addToConfiguration(CompilerConfiguration var1);
    }

    private static class TrackingClassGenerationCompilationCustomizer
    extends IncrementalCompilationCustomizer {
        private final CompilationSourceDirs compilationSourceDirs;
        private final ApiCompilerResult result;
        private final CompilationClassBackupService compilationClassBackupService;

        private TrackingClassGenerationCompilationCustomizer(CompilationSourceDirs compilationSourceDirs, ApiCompilerResult result, CompilationClassBackupService compilationClassBackupService) {
            this.compilationSourceDirs = compilationSourceDirs;
            this.result = result;
            this.compilationClassBackupService = compilationClassBackupService;
        }

        public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) {
            this.inspectClassNode(source, classNode);
        }

        private void inspectClassNode(SourceUnit sourceUnit, ClassNode classNode) {
            String classFqName = classNode.getName();
            String relativePath = (String)this.compilationSourceDirs.relativize(new File(sourceUnit.getSource().getURI().getPath())).orElseThrow(IllegalStateException::new);
            this.result.getSourceClassesMapping().computeIfAbsent(relativePath, key -> new HashSet()).add(classFqName);
            this.compilationClassBackupService.maybeBackupClassFile(classFqName);
            Iterator iterator = classNode.getInnerClasses();
            while (iterator.hasNext()) {
                this.inspectClassNode(sourceUnit, (ClassNode)iterator.next());
            }
        }

        @Override
        public void addToConfiguration(CompilerConfiguration configuration) {
            configuration.addCompilationCustomizers(new CompilationCustomizer[]{this});
        }
    }

    private static class NoOpCompilationCustomizer
    extends IncrementalCompilationCustomizer {
        private NoOpCompilationCustomizer() {
        }

        @Override
        public void addToConfiguration(CompilerConfiguration configuration) {
        }

        public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws org.codehaus.groovy.control.CompilationFailedException {
            throw new UnsupportedOperationException();
        }
    }
}

