/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import org.gradle.api.problems.DocLink;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.GradleVersion;

@ServiceScope(value={Scope.Global.class})
public class DocumentationRegistry {
    public static final String BASE_URL_WITHOUT_VERSION = "https://docs.gradle.org/";
    public static final String BASE_URL = "https://docs.gradle.org/" + GradleVersion.current().getVersion();
    public static final String DSL_PROPERTY_URL_FORMAT = "%s/dsl/%s.html#%s:%s";
    public static final String KOTLIN_DSL_URL_FORMAT = "%s/kotlin-dsl/gradle/%s";
    public static final String LEARN_MORE_STRING = "Learn more about Gradle by exploring our Samples at ";
    public static final String RECOMMENDATION = "For more %s, please refer to %s in the Gradle documentation.";

    public String getDocumentationFor(String id) {
        this.validateId(id);
        return String.format("%s/userguide/%s.html", BASE_URL, id);
    }

    private void validateId(String id) {
        if (id.endsWith(".html") || id.endsWith(".adoc")) {
            throw new IllegalArgumentException("The id '" + id + "' should not end with '.html' or '.adoc'. Provide an id without its file extension to reference documentation.");
        }
        if (id.contains("#")) {
            throw new IllegalArgumentException("The id '" + id + "' should not contain a '#' character. Use getDocumentationFor(id, section) to reference a section anchor in documentation.");
        }
    }

    public String getDocumentationFor(String id, String section) {
        this.validateSection(section);
        return this.getDocumentationFor(id) + "#" + section;
    }

    private void validateSection(String section) {
        if (section.contains("#")) {
            throw new IllegalArgumentException("The section '" + section + "' should not contain a '#' character. Provide only the section name without a leading '#'.");
        }
    }

    public String getDslRefForProperty(Class<?> clazz, String property) {
        String className = clazz.getName();
        return String.format(DSL_PROPERTY_URL_FORMAT, BASE_URL, className, className, property);
    }

    public String getDslRefForProperty(String className, String property) {
        return String.format(DSL_PROPERTY_URL_FORMAT, BASE_URL, className, className, property);
    }

    public String getKotlinDslRefForExtension(String extensionName) {
        return String.format(KOTLIN_DSL_URL_FORMAT, BASE_URL, "org.gradle.kotlin.dsl/" + extensionName + ".html");
    }

    public String getSampleIndex() {
        return BASE_URL + "/samples";
    }

    public String getSampleFor(String id) {
        return String.format(this.getSampleIndex() + "/sample_%s.html", id);
    }

    public String getSampleForMessage(String id) {
        return LEARN_MORE_STRING + this.getSampleFor(id);
    }

    public String getSampleForMessage() {
        return LEARN_MORE_STRING + this.getSampleIndex();
    }

    public String getDocumentationRecommendationFor(String topic, String id) {
        return DocumentationRegistry.getRecommendationString(topic, this.getDocumentationFor(id));
    }

    public String getDocumentationRecommendationFor(String topic, String id, String section) {
        return DocumentationRegistry.getRecommendationString(topic, this.getDocumentationFor(id, section));
    }

    public String getDocumentationRecommendationFor(String topic, DocLink docLink) {
        String url = docLink.getUrl();
        return DocumentationRegistry.getRecommendationString(topic, url == null ? "<N/A>" : url);
    }

    private static String getRecommendationString(String topic, String url) {
        return String.format(RECOMMENDATION, topic.trim(), url);
    }
}

