/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class BuildInitDependency {
    private final String module;
    private final @Nullable String version;
    private final ImmutableList<DependencyExclusion> exclusions;

    private BuildInitDependency(String module, @Nullable String version, List<DependencyExclusion> exclusions) {
        this.module = module;
        this.version = version;
        this.exclusions = ImmutableList.copyOf(exclusions);
    }

    public static BuildInitDependency of(String module, String version) {
        return new BuildInitDependency(module, version, Collections.emptyList());
    }

    public static BuildInitDependency of(String group, String name, String version) {
        return new BuildInitDependency(group + ":" + name, version, Collections.emptyList());
    }

    public static BuildInitDependency of(String group, String name, String version, List<DependencyExclusion> excludes) {
        return new BuildInitDependency(group + ":" + name, version, excludes);
    }

    public static BuildInitDependency of(String module) {
        return new BuildInitDependency(module, null, Collections.emptyList());
    }

    public String getModule() {
        return this.module;
    }

    public @Nullable String getVersion() {
        return this.version;
    }

    public ImmutableList<DependencyExclusion> getExclusions() {
        return this.exclusions;
    }

    public String toNotation() {
        return this.module + (this.version != null ? ":" + this.version : "");
    }

    @NullMarked
    public static final class DependencyExclusion {
        private final String group;
        private final String module;

        public DependencyExclusion(String group, String module) {
            this.group = group;
            this.module = module;
        }

        public String getGroup() {
            return this.group;
        }

        public String getModule() {
            return this.module;
        }
    }
}

