/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.installation;

import java.io.File;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.installation.CurrentGradleInstallation;
import org.gradle.internal.installation.GradleInstallation;
import org.jspecify.annotations.Nullable;

abstract class CurrentGradleInstallationLocator {
    private static final String BEACON_CLASS_NAME = "org.gradle.internal.installation.beacon.InstallationBeacon";

    private CurrentGradleInstallationLocator() {
    }

    public static synchronized CurrentGradleInstallation locate() {
        return CurrentGradleInstallationLocator.locateViaClassLoader(CurrentGradleInstallationLocator.class.getClassLoader());
    }

    private static CurrentGradleInstallation locateViaClassLoader(ClassLoader classLoader) {
        Class<Object> clazz;
        try {
            clazz = classLoader.loadClass(BEACON_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            clazz = CurrentGradleInstallationLocator.class;
        }
        return CurrentGradleInstallationLocator.locateViaClass(clazz);
    }

    static CurrentGradleInstallation locateViaClass(Class<?> clazz) {
        File dir = CurrentGradleInstallationLocator.findDistDir(clazz);
        if (dir == null) {
            return new CurrentGradleInstallation(null);
        }
        return new CurrentGradleInstallation(new GradleInstallation(dir));
    }

    private static @Nullable File findDistDir(Class<?> clazz) {
        File codeSource = ClasspathUtil.getClasspathForClass(clazz);
        if (codeSource.isFile()) {
            return CurrentGradleInstallationLocator.determineDistRootDir(codeSource);
        }
        return null;
    }

    private static @Nullable File determineDistRootDir(File codeSource) {
        File parentDir = codeSource.getParentFile();
        if (parentDir.getName().equals("lib")) {
            File pluginsDir = new File(parentDir, "plugins");
            return parentDir.isDirectory() && pluginsDir.exists() && pluginsDir.isDirectory() ? parentDir.getParentFile() : null;
        }
        if (parentDir.getName().equals("plugins")) {
            File libDir = parentDir.getParentFile();
            return parentDir.isDirectory() && libDir.exists() && libDir.isDirectory() && libDir.getName().equals("lib") ? libDir.getParentFile() : null;
        }
        return null;
    }
}

