/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.classpath;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.classpath.UnknownModuleException;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.installation.GradleInstallation;
import org.gradle.util.internal.GUtil;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class DefaultModuleRegistry
implements ModuleRegistry {
    private final GradleInstallation gradleInstallation;
    private final Map<String, Optional<Module>> modules = new ConcurrentHashMap<String, Optional<Module>>();

    public DefaultModuleRegistry(@Nullable GradleInstallation gradleInstallation) {
        if (gradleInstallation == null) {
            throw new IllegalArgumentException("A Gradle installation is required to execute Gradle.");
        }
        this.gradleInstallation = gradleInstallation;
    }

    @Override
    public @Nullable Module findModule(String moduleName) {
        return this.modules.computeIfAbsent(moduleName, n -> {
            File propertiesFile = this.findPropertiesFile(moduleName);
            if (propertiesFile != null) {
                return Optional.of(DefaultModuleRegistry.createModule(moduleName, propertiesFile));
            }
            return Optional.empty();
        }).orElse(null);
    }

    @Override
    public Module getModule(String name) throws UnknownModuleException {
        Module module = this.findModule(name);
        if (module != null) {
            return module;
        }
        throw new UnknownModuleException(String.format("Cannot find module '%s' in distribution directory '%s'.", name, this.gradleInstallation.getGradleHome()));
    }

    private @Nullable File findPropertiesFile(String name) {
        for (File libDir : this.gradleInstallation.getLibDirs()) {
            File propertiesFile = new File(libDir, name + ".properties");
            if (!propertiesFile.isFile()) continue;
            return propertiesFile;
        }
        return null;
    }

    private static DefaultModule createModule(String moduleName, File propertiesFile) {
        Properties properties = GUtil.loadProperties((File)propertiesFile);
        List<String> dependencies = DefaultModuleRegistry.split(DefaultModuleRegistry.getProperty("dependencies", properties, propertiesFile));
        ClassPath classpath = ClassPath.EMPTY;
        String jarFileName = properties.getProperty("jarFile");
        if (jarFileName != null) {
            File jarFile = new File(propertiesFile.getParent(), jarFileName);
            if (!jarFile.exists()) {
                throw new IllegalArgumentException(String.format("Cannot find JAR '%s' required by module '%s' distribution directory.", jarFileName, moduleName));
            }
            classpath = DefaultClassPath.of((File[])new File[]{jarFile});
        }
        String group = properties.getProperty("alias.group");
        String name = properties.getProperty("alias.name");
        String version = properties.getProperty("alias.version");
        DefaultModuleAlias alias = null;
        if (group != null && name != null && version != null) {
            alias = new DefaultModuleAlias(group, name, version);
        } else if (group != null || name != null || version != null) {
            throw new IllegalArgumentException(String.format("Cannot create module '%s' with partial module alias.", moduleName));
        }
        return new DefaultModule(moduleName, classpath, dependencies, alias);
    }

    private static String getProperty(String propertyName, Properties properties, File propertiesFile) {
        String value = properties.getProperty(propertyName);
        if (value == null) {
            throw new IllegalArgumentException(String.format("Missing required property '%s' in module properties file '%s'.", propertyName, propertiesFile.getAbsolutePath()));
        }
        return value;
    }

    private static List<String> split(String value) {
        String trimmed = value.trim();
        if (trimmed.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(trimmed.split(","));
    }

    public static class DefaultModuleAlias
    implements Module.ModuleAlias {
        private final String group;
        private final String name;
        private final String version;

        private DefaultModuleAlias(String group, String name, String version) {
            this.group = group;
            this.name = name;
            this.version = version;
        }

        @Override
        public String getGroup() {
            return this.group;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getVersion() {
            return this.version;
        }
    }

    private static class DefaultModule
    implements Module {
        private final String name;
        private final List<String> dependencyNames;
        private final ClassPath implementationClasspath;
        private final @Nullable Module.ModuleAlias alias;

        public DefaultModule(String name, ClassPath implementationClasspath, List<String> dependencyNames, @Nullable Module.ModuleAlias alias) {
            this.name = name;
            this.implementationClasspath = implementationClasspath;
            this.dependencyNames = dependencyNames;
            this.alias = alias;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ClassPath getImplementationClasspath() {
            return this.implementationClasspath;
        }

        @Override
        public List<String> getDependencyNames() {
            return this.dependencyNames;
        }

        @Override
        public @Nullable Module.ModuleAlias getAlias() {
            return this.alias;
        }

        public String toString() {
            return "module '" + this.name + "'";
        }
    }
}

