/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.base.Objects;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.initialization.ProjectDescriptorInternal;
import org.gradle.initialization.ProjectDescriptorRegistry;
import org.gradle.internal.Cast;
import org.gradle.internal.FileUtils;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.scripts.DefaultScriptFileResolver;
import org.gradle.internal.scripts.ScriptFileResolver;
import org.gradle.internal.scripts.ScriptResolutionResult;
import org.gradle.util.Path;
import org.gradle.util.internal.NameValidator;
import org.jspecify.annotations.Nullable;

public class DefaultProjectDescriptor
implements ProjectDescriptorInternal {
    public static final String INVALID_NAME_IN_INCLUDE_HINT = "Set the 'rootProject.name' or adjust the 'include' statement (see " + new DocumentationRegistry().getDslRefForProperty(Settings.class, "include(java.lang.String[])") + " for more details).";
    public static final String BUILD_SCRIPT_BASENAME = "build";
    private String name;
    private boolean nameExplicitlySet;
    private final PathToFileResolver fileResolver;
    private final ScriptFileResolver scriptFileResolver;
    private File dir;
    private @Nullable File canonicalDir;
    private final @Nullable ProjectDescriptorInternal parent;
    private final Set<ProjectDescriptorInternal> children = new LinkedHashSet<ProjectDescriptorInternal>();
    private ProjectDescriptorRegistry projectDescriptorRegistry;
    private Path path;
    private @Nullable String buildFileName;

    public DefaultProjectDescriptor(@Nullable ProjectDescriptorInternal parent, String name, File dir, ProjectDescriptorRegistry projectDescriptorRegistry, PathToFileResolver fileResolver) {
        this(parent, name, dir, projectDescriptorRegistry, fileResolver, null);
    }

    public DefaultProjectDescriptor(@Nullable ProjectDescriptorInternal parent, String name, File dir, ProjectDescriptorRegistry projectDescriptorRegistry, PathToFileResolver fileResolver, @Nullable ScriptFileResolver scriptFileResolver) {
        this.parent = parent;
        this.name = name;
        this.fileResolver = fileResolver;
        this.dir = dir;
        this.projectDescriptorRegistry = projectDescriptorRegistry;
        this.path = this.path(name);
        this.scriptFileResolver = scriptFileResolver != null ? scriptFileResolver : new DefaultScriptFileResolver();
        projectDescriptorRegistry.addProject(this);
        if (parent != null) {
            parent.children().add(this);
        }
    }

    private Path path(String name) {
        if (this.isRootDescriptor()) {
            this.path = Path.ROOT;
            return this.path;
        }
        return this.parent.absolutePath(name);
    }

    @Override
    public Path absolutePath(String path) {
        return this.path.child(path);
    }

    private boolean isRootDescriptor() {
        return this.parent == null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        NameValidator.validate(name, "project name", INVALID_NAME_IN_INCLUDE_HINT);
        this.projectDescriptorRegistry.changeDescriptorPath(this.path, this.path(name));
        this.name = name;
        this.nameExplicitlySet = true;
    }

    @Override
    public boolean isExplicitName() {
        return this.nameExplicitlySet;
    }

    public File getProjectDir() {
        if (this.canonicalDir == null) {
            this.canonicalDir = this.fileResolver.resolve((Object)this.dir);
        }
        return this.canonicalDir;
    }

    public void setProjectDir(File dir) {
        this.canonicalDir = null;
        this.dir = dir;
    }

    @Override
    public ProjectDescriptorInternal getParent() {
        return this.parent;
    }

    public Set<ProjectDescriptor> getChildren() {
        return (Set)Cast.uncheckedCast(this.children);
    }

    @Override
    public Set<ProjectDescriptorInternal> children() {
        return this.children;
    }

    public String getPath() {
        return this.path.toString();
    }

    @Override
    public void setPath(Path path) {
        this.path = path;
    }

    public String getBuildFileName() {
        return this.buildFile().getName();
    }

    public void setBuildFileName(String name) {
        this.buildFileName = name;
    }

    public File getBuildFile() {
        return FileUtils.normalize((File)this.buildFile());
    }

    private File buildFile() {
        if (this.buildFileName != null) {
            return new File(this.getProjectDir(), this.buildFileName);
        }
        ScriptResolutionResult buildScriptFileResolution = this.scriptFileResolver.resolveScriptFile(this.getProjectDir(), BUILD_SCRIPT_BASENAME);
        File selectedCandidate = buildScriptFileResolution.getSelectedCandidate();
        if (selectedCandidate != null) {
            return selectedCandidate;
        }
        return new File(this.getProjectDir(), "build.gradle");
    }

    public ProjectDescriptorRegistry getProjectDescriptorRegistry() {
        return this.projectDescriptorRegistry;
    }

    public void setProjectDescriptorRegistry(ProjectDescriptorRegistry projectDescriptorRegistry) {
        this.projectDescriptorRegistry = projectDescriptorRegistry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProjectDescriptor that = (DefaultProjectDescriptor)o;
        return Objects.equal((Object)this.getParent(), (Object)that.getParent()) && Objects.equal((Object)this.getName(), (Object)that.getName());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getParent(), this.getName()});
    }

    public String toString() {
        return this.getPath();
    }

    @Override
    public Path path() {
        return this.path;
    }
}

