/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm;

import com.google.common.collect.ImmutableList;
import java.util.List;

public class JpmsConfiguration {
    private static final List<String> GROOVY_JPMS_ARGS_9 = ImmutableList.of((Object)"--add-opens=java.base/java.lang=ALL-UNNAMED", (Object)"--add-opens=java.base/java.lang.invoke=ALL-UNNAMED", (Object)"--add-opens=java.base/java.util=ALL-UNNAMED", (Object)"--add-opens=java.prefs/java.util.prefs=ALL-UNNAMED", (Object)"--add-exports=jdk.compiler/com.sun.tools.javac.api=ALL-UNNAMED", (Object)"--add-exports=jdk.compiler/com.sun.tools.javac.util=ALL-UNNAMED");
    private static final List<String> GRADLE_SHARED_JPMS_ARGS_24 = ImmutableList.of((Object)"--enable-native-access=ALL-UNNAMED");
    private static final List<String> GRADLE_WORKER_JPMS_ARGS_24 = GRADLE_SHARED_JPMS_ARGS_24;
    private static final List<String> GRADLE_DAEMON_JPMS_ARGS_9 = ImmutableList.builder().addAll(GROOVY_JPMS_ARGS_9).add((Object)"--add-opens=java.base/java.nio.charset=ALL-UNNAMED").add((Object)"--add-opens=java.base/java.net=ALL-UNNAMED").add((Object)"--add-opens=java.base/java.util.concurrent=ALL-UNNAMED").add((Object)"--add-opens=java.base/java.util.concurrent.atomic=ALL-UNNAMED").add((Object)"--add-opens=java.xml/javax.xml.namespace=ALL-UNNAMED").add((Object)"--add-opens=java.base/java.time=ALL-UNNAMED").build();
    private static final List<String> GRADLE_DAEMON_JPMS_ARGS_24 = ImmutableList.builder().addAll(GRADLE_DAEMON_JPMS_ARGS_9).addAll(GRADLE_SHARED_JPMS_ARGS_24).build();

    public static List<String> forGroovyCompilerWorker(int majorVersion) {
        if (majorVersion < 9) {
            return ImmutableList.of();
        }
        return GROOVY_JPMS_ARGS_9;
    }

    public static List<String> forWorkerProcesses(int majorVersion, boolean usingNativeServices) {
        if (majorVersion < 24 || !usingNativeServices) {
            return ImmutableList.of();
        }
        return GRADLE_WORKER_JPMS_ARGS_24;
    }

    public static List<String> forDaemonProcesses(int majorVersion, boolean usingNativeServices) {
        if (majorVersion < 9) {
            return ImmutableList.of();
        }
        if (majorVersion < 24 || !usingNativeServices) {
            return GRADLE_DAEMON_JPMS_ARGS_9;
        }
        return GRADLE_DAEMON_JPMS_ARGS_24;
    }
}

