/*
 * Copyright 2025 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.launcher.daemon.server;

import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.launcher.daemon.logging.DaemonLogConstants;
import org.jspecify.annotations.Nullable;

import java.io.File;
import java.util.UUID;

/**
 * Carries the location of the log file for the current daemon.
 */
@ServiceScope(Scope.Global.class)
public class DaemonLogFile {
    private final File file;

    public DaemonLogFile(File file) {
        this.file = file;
    }

    public static String getDaemonLogFileName(@Nullable Long pid) {
        return DaemonLogConstants.DAEMON_LOG_PREFIX + (pid == null ? UUID.randomUUID() : pid) + DaemonLogConstants.DAEMON_LOG_SUFFIX;
    }

    public File getFile() {
        return file;
    }
}
