/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.application.tasks;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Incubating;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.plugins.AppEntryPoint;
import org.gradle.api.internal.plugins.MainClass;
import org.gradle.api.internal.plugins.MainModule;
import org.gradle.api.internal.plugins.StartScriptGenerator;
import org.gradle.api.internal.plugins.UnixStartScriptGenerator;
import org.gradle.api.internal.plugins.WindowsStartScriptGenerator;
import org.gradle.api.jvm.ModularitySpec;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.internal.jvm.DefaultModularitySpec;
import org.gradle.internal.jvm.JavaModuleDetector;
import org.gradle.jvm.application.scripts.ScriptGenerator;
import org.gradle.util.internal.GUtil;
import org.gradle.work.DisableCachingByDefault;
import org.jspecify.annotations.Nullable;

@DisableCachingByDefault(because="Not worth caching")
public abstract class CreateStartScripts
extends ConventionTask {
    private File outputDir;
    private String executableDir = "bin";
    private final Property<String> mainModule;
    private final Property<String> mainClass;
    private Iterable<String> defaultJvmOpts = new LinkedList<String>();
    private String applicationName;
    private String optsEnvironmentVar;
    private String exitEnvironmentVar;
    private FileCollection classpath;
    private final ModularitySpec modularity;
    private ScriptGenerator unixStartScriptGenerator = new UnixStartScriptGenerator();
    private ScriptGenerator windowsStartScriptGenerator = new WindowsStartScriptGenerator();

    public CreateStartScripts() {
        this.mainModule = this.getObjectFactory().property(String.class);
        this.mainClass = this.getObjectFactory().property(String.class);
        this.getGitRef().convention((Object)"HEAD");
        this.modularity = (ModularitySpec)this.getObjectFactory().newInstance(DefaultModularitySpec.class, new Object[0]);
    }

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    @Inject
    protected abstract JavaModuleDetector getJavaModuleDetector();

    @Optional
    @Input
    @ToBeReplacedByLazyProperty
    public @Nullable String getOptsEnvironmentVar() {
        if (GUtil.isTrue((Object)this.optsEnvironmentVar)) {
            return this.optsEnvironmentVar;
        }
        if (!GUtil.isTrue((Object)this.getApplicationName())) {
            return null;
        }
        return GUtil.toConstant((CharSequence)this.getApplicationName()) + "_OPTS";
    }

    @Optional
    @Input
    @ToBeReplacedByLazyProperty
    public @Nullable String getExitEnvironmentVar() {
        if (GUtil.isTrue((Object)this.exitEnvironmentVar)) {
            return this.exitEnvironmentVar;
        }
        if (!GUtil.isTrue((Object)this.getApplicationName())) {
            return null;
        }
        return GUtil.toConstant((CharSequence)this.getApplicationName()) + "_EXIT_CONSOLE";
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public File getUnixScript() {
        return new File(this.getOutputDir(), this.getApplicationName());
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public File getWindowsScript() {
        return new File(this.getOutputDir(), this.getApplicationName() + ".bat");
    }

    @OutputDirectory
    @ToBeReplacedByLazyProperty
    public @Nullable File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(@Nullable File outputDir) {
        this.outputDir = outputDir;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public String getExecutableDir() {
        return this.executableDir;
    }

    public void setExecutableDir(String executableDir) {
        this.executableDir = executableDir;
    }

    @Optional
    @Input
    public Property<String> getMainModule() {
        return this.mainModule;
    }

    @Optional
    @Input
    public Property<String> getMainClass() {
        return this.mainClass;
    }

    @Optional
    @Input
    @ToBeReplacedByLazyProperty
    public @Nullable Iterable<String> getDefaultJvmOpts() {
        return this.defaultJvmOpts;
    }

    public void setDefaultJvmOpts(@Nullable Iterable<String> defaultJvmOpts) {
        this.defaultJvmOpts = defaultJvmOpts;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public @Nullable String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(@Nullable String applicationName) {
        this.applicationName = applicationName;
    }

    @Incubating
    @Optional
    @Input
    public abstract Property<String> getGitRef();

    public void setOptsEnvironmentVar(@Nullable String optsEnvironmentVar) {
        this.optsEnvironmentVar = optsEnvironmentVar;
    }

    public void setExitEnvironmentVar(@Nullable String exitEnvironmentVar) {
        this.exitEnvironmentVar = exitEnvironmentVar;
    }

    @Classpath
    @Optional
    @ToBeReplacedByLazyProperty
    public @Nullable FileCollection getClasspath() {
        return this.classpath;
    }

    @Nested
    public ModularitySpec getModularity() {
        return this.modularity;
    }

    public void setClasspath(@Nullable FileCollection classpath) {
        this.classpath = classpath;
    }

    @Nested
    public ScriptGenerator getUnixStartScriptGenerator() {
        return this.unixStartScriptGenerator;
    }

    public void setUnixStartScriptGenerator(ScriptGenerator unixStartScriptGenerator) {
        this.unixStartScriptGenerator = unixStartScriptGenerator;
    }

    @Nested
    public ScriptGenerator getWindowsStartScriptGenerator() {
        return this.windowsStartScriptGenerator;
    }

    public void setWindowsStartScriptGenerator(ScriptGenerator windowsStartScriptGenerator) {
        this.windowsStartScriptGenerator = windowsStartScriptGenerator;
    }

    @TaskAction
    public void generate() {
        StartScriptGenerator generator = new StartScriptGenerator(this.unixStartScriptGenerator, this.windowsStartScriptGenerator);
        JavaModuleDetector javaModuleDetector = this.getJavaModuleDetector();
        generator.setApplicationName(this.getApplicationName());
        generator.setGitRef((String)this.getGitRef().get());
        generator.setEntryPoint(this.getEntryPoint());
        generator.setDefaultJvmOpts(this.getDefaultJvmOpts());
        generator.setOptsEnvironmentVar(this.getOptsEnvironmentVar());
        generator.setExitEnvironmentVar(this.getExitEnvironmentVar());
        generator.setClasspath(this.getRelativePath(javaModuleDetector.inferClasspath(this.mainModule.isPresent(), this.getClasspath())));
        generator.setModulePath(this.getRelativePath(javaModuleDetector.inferModulePath(this.mainModule.isPresent(), this.getClasspath())));
        if (StringUtils.isEmpty((CharSequence)this.getExecutableDir())) {
            generator.setScriptRelPath(this.getUnixScript().getName());
        } else {
            generator.setScriptRelPath(this.getExecutableDir() + "/" + this.getUnixScript().getName());
        }
        generator.generateUnixScript(this.getUnixScript());
        generator.generateWindowsScript(this.getWindowsScript());
    }

    private AppEntryPoint getEntryPoint() {
        if (this.mainModule.isPresent()) {
            return new MainModule((String)this.mainModule.get(), (String)this.mainClass.getOrNull());
        }
        return new MainClass((String)this.mainClass.getOrElse((Object)""));
    }

    @Input
    @ToBeReplacedByLazyProperty(unreported=true, comment="Skipped for report since method is protected")
    protected Iterable<String> getRelativeClasspath() {
        FileCollection classpathNullable = this.getClasspath();
        if (classpathNullable == null) {
            return Collections.emptyList();
        }
        return this.getRelativePath(classpathNullable);
    }

    private Iterable<String> getRelativePath(FileCollection path) {
        return path.getFiles().stream().map(input -> "lib/" + input.getName()).collect(Collectors.toCollection(Lists::newArrayList));
    }
}

