/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.authentication.http.BasicAuthentication;
import org.gradle.authentication.http.DigestAuthentication;
import org.gradle.authentication.http.HttpHeaderAuthentication;
import org.gradle.internal.authentication.AuthenticationSchemeRegistry;
import org.gradle.internal.authentication.DefaultBasicAuthentication;
import org.gradle.internal.authentication.DefaultDigestAuthentication;
import org.gradle.internal.authentication.DefaultHttpHeaderAuthentication;
import org.gradle.internal.resource.connector.ResourceConnectorFactory;
import org.gradle.internal.resource.transport.http.ApacheCommonsHttpClientFactory;
import org.gradle.internal.resource.transport.http.DefaultSslContextFactory;
import org.gradle.internal.resource.transport.http.HttpClientFactory;
import org.gradle.internal.resource.transport.http.HttpConnectorFactory;
import org.gradle.internal.resource.transport.http.SslContextFactory;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.scopes.AbstractGradleModuleServices;

public class HttpResourcesServices
extends AbstractGradleModuleServices {
    public void registerGlobalServices(ServiceRegistration registration) {
        registration.addProvider((ServiceRegistrationProvider)new GlobalScopeServices());
    }

    public void registerBuildServices(ServiceRegistration registration) {
        registration.addProvider((ServiceRegistrationProvider)new AuthenticationSchemeAction());
    }

    private static class GlobalScopeServices
    implements ServiceRegistrationProvider {
        private GlobalScopeServices() {
        }

        @Provides
        SslContextFactory createSslContextFactory() {
            return new DefaultSslContextFactory();
        }

        @Provides
        HttpClientFactory createHttpClientHelperFactory(DocumentationRegistry documentationRegistry) {
            return new ApacheCommonsHttpClientFactory(documentationRegistry);
        }

        @Provides
        ResourceConnectorFactory createHttpConnectorFactory(SslContextFactory sslContextFactory, HttpClientFactory httpClientHelperFactory) {
            return new HttpConnectorFactory(sslContextFactory, httpClientHelperFactory);
        }
    }

    private static class AuthenticationSchemeAction
    implements ServiceRegistrationProvider {
        private AuthenticationSchemeAction() {
        }

        @Provides
        public void configure(ServiceRegistration registration, AuthenticationSchemeRegistry authenticationSchemeRegistry) {
            authenticationSchemeRegistry.registerScheme(BasicAuthentication.class, DefaultBasicAuthentication.class);
            authenticationSchemeRegistry.registerScheme(DigestAuthentication.class, DefaultDigestAuthentication.class);
            authenticationSchemeRegistry.registerScheme(HttpHeaderAuthentication.class, DefaultHttpHeaderAuthentication.class);
        }
    }
}

