/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.IOException;
import java.net.URI;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ReadableContent;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;
import org.gradle.internal.resource.transport.http.HttpClient;
import org.gradle.internal.resource.transport.http.HttpErrorStatusCodeException;

public class HttpResourceUploader
implements ExternalResourceUploader {
    private final HttpClient http;

    public HttpResourceUploader(HttpClient http) {
        this.http = http;
    }

    public void upload(ReadableContent resource, ExternalResourceName destination) throws IOException {
        try (HttpClient.Response response = this.http.performRawPut(destination.getUri(), resource);){
            if (!response.isSuccessful()) {
                URI effectiveUri = response.getEffectiveUri();
                throw new HttpErrorStatusCodeException(response.getMethod(), effectiveUri.toString(), response.getStatusCode(), response.getStatusReason());
            }
        }
    }
}

