/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.net.URI;
import org.gradle.internal.IoActions;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.AbstractExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transport.http.HttpClient;
import org.gradle.internal.resource.transport.http.HttpResponseResource;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResourceAccessor
extends AbstractExternalResourceAccessor
implements ExternalResourceAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResourceAccessor.class);
    private static final ImmutableMap<String, String> REVALIDATE_HEADERS = ImmutableMap.of((Object)"Cache-Control", (Object)"max-age=0");
    private final HttpClient client;

    public HttpResourceAccessor(HttpClient client) {
        this.client = client;
    }

    public @Nullable HttpResponseResource openResource(ExternalResourceName location, boolean revalidate) {
        LOGGER.debug("Constructing external resource: {}", (Object)location);
        URI uri = location.getUri();
        HttpClient.Response response = this.client.performGet(uri, HttpResourceAccessor.getHeaders(revalidate));
        return this.wrapResponse(uri, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalResourceMetaData getMetaData(ExternalResourceName location, boolean revalidate) {
        LOGGER.debug("Constructing external resource metadata: {}", (Object)location);
        URI uri = location.getUri();
        HttpClient.Response response = this.client.performHead(uri, HttpResourceAccessor.getHeaders(revalidate));
        if (response.isMissing()) {
            return null;
        }
        HttpResponseResource resource = new HttpResponseResource("HEAD", uri, response);
        try {
            ExternalResourceMetaData externalResourceMetaData = resource.getMetaData();
            return externalResourceMetaData;
        }
        finally {
            IoActions.closeQuietly((Closeable)((Object)resource));
        }
    }

    private HttpResponseResource wrapResponse(URI uri, HttpClient.Response response) {
        return new HttpResponseResource("GET", uri, response);
    }

    private static ImmutableMap<String, String> getHeaders(boolean revalidate) {
        return revalidate ? REVALIDATE_HEADERS : ImmutableMap.of();
    }
}

