/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resource.ReadableContent;
import org.gradle.internal.resource.transport.http.ApacheHttpResponse;
import org.gradle.internal.resource.transport.http.HttpClient;
import org.gradle.internal.resource.transport.http.HttpClientConfigurer;
import org.gradle.internal.resource.transport.http.HttpErrorStatusCodeException;
import org.gradle.internal.resource.transport.http.HttpRequestException;
import org.gradle.internal.resource.transport.http.HttpSettings;
import org.gradle.internal.resource.transport.http.RepeatableInputStreamEntity;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public class ApacheCommonsHttpClient
implements HttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApacheCommonsHttpClient.class);
    private final DocumentationRegistry documentationRegistry;
    private final HttpSettings settings;
    private final Supplier<HttpClientBuilder> clientBuilderFactory;
    private Collection<String> supportedTlsVersions;
    private @Nullable CloseableHttpClient client;
    private final @Nullable ConcurrentLinkedQueue<HttpContext> sharedContext;

    ApacheCommonsHttpClient(DocumentationRegistry documentationRegistry, HttpSettings settings) {
        this(documentationRegistry, settings, HttpClientBuilder::create);
    }

    @VisibleForTesting
    ApacheCommonsHttpClient(DocumentationRegistry documentationRegistry, HttpSettings settings, Supplier<HttpClientBuilder> clientBuilderFactory) {
        this.documentationRegistry = documentationRegistry;
        this.settings = settings;
        this.clientBuilderFactory = clientBuilderFactory;
        this.sharedContext = !settings.getAuthenticationSettings().isEmpty() ? new ConcurrentLinkedQueue() : null;
    }

    @Override
    public HttpClient.Response performHead(URI uri, ImmutableMap<String, String> headers) {
        HttpHead request = new HttpHead(uri);
        ApacheCommonsHttpClient.addHeaders((HttpRequestBase)request, headers);
        return ApacheCommonsHttpClient.processResponse(this.performRequest((HttpRequestBase)request));
    }

    @Override
    public HttpClient.Response performGet(URI uri, ImmutableMap<String, String> headers) {
        HttpGet request = new HttpGet(uri);
        ApacheCommonsHttpClient.addHeaders((HttpRequestBase)request, headers);
        return ApacheCommonsHttpClient.processResponse(this.performRequest((HttpRequestBase)request));
    }

    @Override
    public HttpClient.Response performRawGet(URI uri, ImmutableMap<String, String> headers) throws IOException {
        HttpGet httpGet = new HttpGet(uri);
        ApacheCommonsHttpClient.addHeaders((HttpRequestBase)httpGet, headers);
        return this.performRawRequest((HttpRequestBase)httpGet);
    }

    @Override
    public HttpClient.Response performRawPut(URI uri, ReadableContent resource) throws IOException {
        HttpPut method = new HttpPut(uri);
        RepeatableInputStreamEntity entity = new RepeatableInputStreamEntity(resource, ContentType.APPLICATION_OCTET_STREAM);
        method.setEntity((HttpEntity)entity);
        return this.performRawRequest((HttpRequestBase)method);
    }

    @Override
    public HttpClient.Response performRawPut(URI uri, ImmutableMap<String, String> headers, final HttpClient.WritableContent resource) throws IOException {
        HttpPut httpPut = new HttpPut(uri);
        ApacheCommonsHttpClient.addHeaders((HttpRequestBase)httpPut, headers);
        httpPut.setEntity((HttpEntity)new AbstractHttpEntity(){

            public boolean isRepeatable() {
                return true;
            }

            public long getContentLength() {
                return resource.getSize();
            }

            public InputStream getContent() {
                throw new UnsupportedOperationException();
            }

            public void writeTo(OutputStream outstream) throws IOException {
                resource.writeTo(outstream);
            }

            public boolean isStreaming() {
                return false;
            }
        });
        return this.performRawRequest((HttpRequestBase)httpPut);
    }

    private HttpClient.Response performRequest(HttpRequestBase request) {
        try {
            return this.performRawRequest(request);
        }
        catch (FailureFromRedirectLocation e) {
            throw ApacheCommonsHttpClient.createHttpRequestException(request.getMethod(), e.getCause(), e.getLastRedirectLocation());
        }
        catch (IOException e) {
            throw ApacheCommonsHttpClient.createHttpRequestException(request.getMethod(), this.wrapWithExplanation(e), request.getURI());
        }
    }

    private static void addHeaders(HttpRequestBase request, ImmutableMap<String, String> headers) {
        for (Map.Entry entry : headers.entrySet()) {
            request.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private static HttpRequestException createHttpRequestException(String method, Throwable cause, URI uri) {
        return new HttpRequestException(String.format("Could not %s '%s'.", method, ApacheCommonsHttpClient.stripUserCredentials(uri)), cause);
    }

    private Exception wrapWithExplanation(IOException e) {
        if (e instanceof SocketException || e instanceof SSLException && e.getMessage().contains("readHandshakeRecord")) {
            return new HttpRequestException("Got socket exception during request. It might be caused by SSL misconfiguration", e);
        }
        if (!(e instanceof SSLHandshakeException)) {
            return e;
        }
        SSLHandshakeException sslException = (SSLHandshakeException)e;
        String message = e.getMessage().contains("PKIX path building failed") || e.getMessage().contains("certificate_unknown") ? "Got SSL handshake exception during request. It might be caused by SSL misconfiguration" : String.format("The server %s not support the client's requested TLS protocol versions: (%s). You may need to configure the client to allow other protocols to be used. %s", ApacheCommonsHttpClient.getConfidenceNote(sslException), String.join((CharSequence)", ", this.supportedTlsVersions), this.documentationRegistry.getDocumentationRecommendationFor("on this", "build_environment", "sec:gradle_system_properties"));
        return new HttpRequestException(message, e);
    }

    private static String getConfidenceNote(SSLHandshakeException sslException) {
        if (sslException.getMessage() != null && sslException.getMessage().contains("protocol_version")) {
            return "does";
        }
        return "may";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpClient.Response performRawRequest(HttpRequestBase request) throws IOException {
        if (this.sharedContext == null) {
            return this.performHttpRequest(request, (HttpContext)new BasicHttpContext());
        }
        HttpContext httpContext = this.nextAvailableSharedContext();
        try {
            HttpClient.Response response = this.performHttpRequest(request, httpContext);
            return response;
        }
        finally {
            this.sharedContext.add(httpContext);
        }
    }

    private HttpContext nextAvailableSharedContext() {
        HttpContext context = this.sharedContext.poll();
        if (context == null) {
            return new BasicHttpContext();
        }
        return context;
    }

    private HttpClient.Response performHttpRequest(HttpRequestBase request, HttpContext httpContext) throws IOException {
        httpContext.removeAttribute("http.protocol.redirect-locations");
        LOGGER.debug("Performing HTTP {}: {}", (Object)request.getMethod(), (Object)ApacheCommonsHttpClient.stripUserCredentials(request.getURI()));
        try {
            CloseableHttpResponse response = this.getClient().execute((HttpUriRequest)request, httpContext);
            return this.toHttpClientResponse(request, httpContext, response);
        }
        catch (IOException e) {
            this.validateRedirectChain(httpContext);
            URI lastRedirectLocation = ApacheCommonsHttpClient.stripUserCredentials(ApacheCommonsHttpClient.getLastRedirectLocation(httpContext));
            if (lastRedirectLocation == null) {
                throw e;
            }
            throw new FailureFromRedirectLocation(lastRedirectLocation, e);
        }
    }

    private HttpClient.Response toHttpClientResponse(HttpRequestBase request, HttpContext httpContext, CloseableHttpResponse response) {
        this.validateRedirectChain(httpContext);
        URI lastRedirectLocation = ApacheCommonsHttpClient.getLastRedirectLocation(httpContext);
        URI effectiveUri = lastRedirectLocation == null ? request.getURI() : lastRedirectLocation;
        return new ApacheHttpResponse(request.getMethod(), effectiveUri, response);
    }

    private void validateRedirectChain(HttpContext httpContext) {
        this.settings.getRedirectVerifier().validateRedirects(ApacheCommonsHttpClient.getRedirectLocations(httpContext));
    }

    private static List<URI> getRedirectLocations(HttpContext httpContext) {
        List redirects = (List)httpContext.getAttribute("http.protocol.redirect-locations");
        return redirects == null ? Collections.emptyList() : redirects;
    }

    private static @Nullable URI getLastRedirectLocation(HttpContext httpContext) {
        List<URI> redirectLocations = ApacheCommonsHttpClient.getRedirectLocations(httpContext);
        return redirectLocations.isEmpty() ? null : (URI)Iterables.getLast(redirectLocations);
    }

    private static HttpClient.Response processResponse(HttpClient.Response response) {
        if (response.isSuccessful()) {
            return response;
        }
        response.close();
        if (response.isMissing()) {
            LOGGER.info("Resource missing. [HTTP {}: {}]", (Object)response.getMethod(), (Object)ApacheCommonsHttpClient.stripUserCredentials(response.getEffectiveUri()));
            return response;
        }
        URI effectiveUri = ApacheCommonsHttpClient.stripUserCredentials(response.getEffectiveUri());
        LOGGER.info("Failed to get resource: {}. [HTTP {}: {})]", new Object[]{response.getMethod(), response.getStatusCode(), effectiveUri});
        throw new HttpErrorStatusCodeException(response.getMethod(), effectiveUri.toString(), response.getStatusCode(), response.getStatusReason());
    }

    private synchronized CloseableHttpClient getClient() {
        if (this.client == null) {
            HttpClientBuilder builder = this.clientBuilderFactory.get();
            HttpClientConfigurer configurer = new HttpClientConfigurer(this.settings);
            configurer.configure(builder);
            this.supportedTlsVersions = configurer.supportedTlsVersions();
            this.client = builder.build();
        }
        return this.client;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.client != null) {
            this.client.close();
            if (this.sharedContext != null) {
                this.sharedContext.clear();
            }
        }
    }

    @VisibleForTesting
    static @Nullable URI stripUserCredentials(@Nullable URI uri) {
        if (uri == null) {
            return null;
        }
        try {
            return new URIBuilder(uri).setUserInfo(null).build();
        }
        catch (URISyntaxException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e, (boolean)true);
        }
    }

    private static class FailureFromRedirectLocation
    extends IOException {
        private final URI lastRedirectLocation;

        private FailureFromRedirectLocation(URI lastRedirectLocation, Throwable cause) {
            super(cause);
            this.lastRedirectLocation = lastRedirectLocation;
        }

        private URI getLastRedirectLocation() {
            return this.lastRedirectLocation;
        }
    }
}

