/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.versioning;

import java.io.Serializable;
import org.gradle.util.GradleVersion;

public abstract class VersionDetails
implements Serializable {
    private final String providerVersion;

    public static VersionDetails from(String version) {
        return VersionDetails.from(GradleVersion.version((String)version));
    }

    public static VersionDetails from(GradleVersion version) {
        if (version.getBaseVersion().compareTo(GradleVersion.version((String)"9.4")) >= 0) {
            return new R94VersionDetails(version.getVersion());
        }
        if (version.getBaseVersion().compareTo(GradleVersion.version((String)"5.1")) >= 0) {
            return new R51VersionDetails(version.getVersion());
        }
        if (version.getBaseVersion().compareTo(GradleVersion.version((String)"4.8")) >= 0) {
            return new R48VersionDetails(version.getVersion());
        }
        if (version.getBaseVersion().compareTo(GradleVersion.version((String)"4.4")) >= 0) {
            return new R44VersionDetails(version.getVersion());
        }
        if (version.getBaseVersion().compareTo(GradleVersion.version((String)"3.5")) >= 0) {
            return new R35VersionDetails(version.getVersion());
        }
        if (version.getBaseVersion().compareTo(GradleVersion.version((String)"2.8")) >= 0) {
            return new R28VersionDetails(version.getVersion());
        }
        return new R26VersionDetails(version.getVersion());
    }

    protected VersionDetails(String version) {
        this.providerVersion = version;
    }

    public String getVersion() {
        return this.providerVersion;
    }

    public boolean maySupportModel(Class<?> modelType) {
        return false;
    }

    public boolean supportsEnvironmentVariablesCustomization() {
        return false;
    }

    public boolean supportsRunTasksBeforeExecutingAction() {
        return false;
    }

    public boolean supportsParameterizedToolingModels() {
        return false;
    }

    public boolean supportsRunPhasedActions() {
        return false;
    }

    public boolean supportsPluginClasspathInjection() {
        return false;
    }

    public boolean supportsHelpToolingModel() {
        return false;
    }

    public boolean honorsContractOnCancel() {
        return false;
    }

    private static class R94VersionDetails
    extends R51VersionDetails {
        R94VersionDetails(String version) {
            super(version);
        }

        @Override
        public boolean supportsHelpToolingModel() {
            return true;
        }
    }

    private static class R51VersionDetails
    extends R48VersionDetails {
        R51VersionDetails(String version) {
            super(version);
        }

        @Override
        public boolean honorsContractOnCancel() {
            return true;
        }
    }

    private static class R48VersionDetails
    extends R44VersionDetails {
        R48VersionDetails(String version) {
            super(version);
        }

        @Override
        public boolean supportsRunPhasedActions() {
            return true;
        }
    }

    private static class R44VersionDetails
    extends R35VersionDetails {
        R44VersionDetails(String version) {
            super(version);
        }

        @Override
        public boolean supportsParameterizedToolingModels() {
            return true;
        }
    }

    private static class R35VersionDetails
    extends R28VersionDetails {
        R35VersionDetails(String version) {
            super(version);
        }

        @Override
        public boolean supportsEnvironmentVariablesCustomization() {
            return true;
        }

        @Override
        public boolean supportsRunTasksBeforeExecutingAction() {
            return true;
        }
    }

    private static class R28VersionDetails
    extends R26VersionDetails {
        R28VersionDetails(String version) {
            super(version);
        }

        @Override
        public boolean supportsPluginClasspathInjection() {
            return true;
        }
    }

    private static class R26VersionDetails
    extends VersionDetails {
        R26VersionDetails(String version) {
            super(version);
        }

        @Override
        public boolean maySupportModel(Class<?> modelType) {
            return true;
        }
    }
}

