/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.resolver.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.AuthenticationSupported;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.credentials.HttpHeaderCredentials;
import org.gradle.kotlin.dsl.resolver.internal.GradleDistRepoDescriptor;
import org.gradle.kotlin.dsl.resolver.internal.GradleDistRepoDescriptorLocator;
import org.gradle.kotlin.dsl.resolver.internal.GradleDistRepoDescriptorLocatorKt;
import org.gradle.kotlin.dsl.resolver.internal.GradleDistVersion;
import org.gradle.util.internal.WrapperCredentials;
import org.gradle.util.internal.WrapperDistributionUrlConverter;
import org.gradle.wrapper.WrapperExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u0018H\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0010H\u0002J*\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u000e2\b\u0010!\u001a\u0004\u0018\u00010\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\""}, d2={"Lorg/gradle/kotlin/dsl/resolver/internal/GradleDistRepoDescriptorLocator;", "", "project", "Lorg/gradle/api/Project;", "gradleVersion", "Lorg/gradle/kotlin/dsl/resolver/internal/GradleDistVersion;", "explicitRootProjectDir", "Ljava/io/File;", "<init>", "(Lorg/gradle/api/Project;Lorg/gradle/kotlin/dsl/resolver/internal/GradleDistVersion;Ljava/io/File;)V", "getGradleVersion", "()Lorg/gradle/kotlin/dsl/resolver/internal/GradleDistVersion;", "rootProjectDir", "repositoryName", "", "gradleDistRepository", "Lorg/gradle/kotlin/dsl/resolver/internal/GradleDistRepoDescriptor;", "getGradleDistRepository", "()Lorg/gradle/kotlin/dsl/resolver/internal/GradleDistRepoDescriptor;", "defaultGradleDistRepository", "getDefaultGradleDistRepository", "wrapperCredentials", "Lorg/gradle/util/internal/WrapperCredentials;", "baseUrl", "Ljava/net/URI;", "findStandardWrapperUri", "findStandardCustomBasePath", "customUri", "findCustomGradleDistRepository", "gradleDistRepoDescriptor", "repoName", "repoBaseUrl", "artifactPattern", "credentials", "kotlin-dsl"})
@SourceDebugExtension(value={"SMAP\nGradleDistRepoDescriptorLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleDistRepoDescriptorLocator.kt\norg/gradle/kotlin/dsl/resolver/internal/GradleDistRepoDescriptorLocator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1#2:158\n*E\n"})
public final class GradleDistRepoDescriptorLocator {
    @NotNull
    private final Project project;
    @NotNull
    private final GradleDistVersion gradleVersion;
    @NotNull
    private final File rootProjectDir;
    @NotNull
    private final String repositoryName;

    public GradleDistRepoDescriptorLocator(@NotNull Project project, @NotNull GradleDistVersion gradleVersion, @Nullable File explicitRootProjectDir) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
        this.project = project;
        this.gradleVersion = gradleVersion;
        File file = explicitRootProjectDir;
        if (file == null) {
            File file2 = this.project.getLayout().getSettingsDirectory().getAsFile();
            file = file2;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAsFile(...)");
        }
        this.rootProjectDir = file;
        this.repositoryName = this.gradleVersion.isSnapshot() ? "distributions-snapshots" : "distributions";
    }

    public /* synthetic */ GradleDistRepoDescriptorLocator(Project project, GradleDistVersion gradleDistVersion, File file, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            String string = project.getGradle().getGradleVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGradleVersion(...)");
            gradleDistVersion = new GradleDistVersion(string);
        }
        if ((n & 4) != 0) {
            file = null;
        }
        this(project, gradleDistVersion, file);
    }

    @NotNull
    public final GradleDistVersion getGradleVersion() {
        return this.gradleVersion;
    }

    @NotNull
    public final GradleDistRepoDescriptor getGradleDistRepository() {
        GradleDistRepoDescriptor gradleDistRepoDescriptor2;
        try {
            GradleDistRepoDescriptor gradleDistRepoDescriptor3 = this.findCustomGradleDistRepository();
            if (gradleDistRepoDescriptor3 == null) {
                gradleDistRepoDescriptor3 = this.getDefaultGradleDistRepository();
            }
            gradleDistRepoDescriptor2 = gradleDistRepoDescriptor3;
        }
        catch (Exception ex) {
            this.project.getLogger().warn("Unexpected exception while trying to find the URL for Gradle sources: " + ex.getMessage(), (Throwable)ex);
            gradleDistRepoDescriptor2 = this.getDefaultGradleDistRepository();
        }
        return gradleDistRepoDescriptor2;
    }

    private final GradleDistRepoDescriptor getDefaultGradleDistRepository() {
        URI uRI = URI.create("https://services.gradle.org/" + this.repositoryName);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
        return this.gradleDistRepoDescriptor(this.repositoryName, uRI, "[module]-[revision](-[classifier])(.[ext])", null);
    }

    private final WrapperCredentials wrapperCredentials(URI baseUrl) {
        return WrapperCredentials.findCredentials((URI)baseUrl, (Function)wrapperCredentials.1.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final URI findStandardWrapperUri() {
        File wrapperProperties = WrapperExecutor.wrapperPropertiesForProjectDirectory((File)this.rootProjectDir);
        if (wrapperProperties.exists()) {
            URI currentWrapperUri;
            URI uRI;
            Properties properties;
            Properties $this$findStandardWrapperUri_u24lambda_u240 = properties = new Properties();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)wrapperProperties);
            Closeable closeable = new FileInputStream(wrapperProperties);
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)closeable;
                boolean bl2 = false;
                $this$findStandardWrapperUri_u24lambda_u240.load(it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String string = properties.getProperty("distributionUrl");
            if (string != null) {
                String it = string;
                boolean bl3 = false;
                uRI = WrapperDistributionUrlConverter.convertDistributionUrl((String)it, (File)wrapperProperties.getParentFile());
            } else {
                uRI = currentWrapperUri = null;
            }
            if (currentWrapperUri != null && !Intrinsics.areEqual((Object)currentWrapperUri.getHost(), (Object)"services.gradle.org") && currentWrapperUri.getRawFragment() == null && currentWrapperUri.getRawQuery() == null) {
                return currentWrapperUri;
            }
        }
        return null;
    }

    private final String findStandardCustomBasePath(URI customUri) {
        String string = customUri.getPath();
        if (string == null) {
            return null;
        }
        String uriPath = string;
        int fileNameSepIndex = StringsKt.lastIndexOf$default((CharSequence)uriPath, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (fileNameSepIndex >= 0) {
            String string2 = uriPath.substring(fileNameSepIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String fileNamePath = string2;
            CharSequence charSequence = fileNamePath;
            if (GradleDistRepoDescriptorLocatorKt.access$getSTANDARD_GRADLE_DIST_FILENAME_REGEX$p().matches(charSequence)) {
                return StringsKt.take((String)uriPath, (int)fileNameSepIndex);
            }
        }
        return null;
    }

    private final GradleDistRepoDescriptor findCustomGradleDistRepository() {
        URI uRI = this.findStandardWrapperUri();
        if (uRI == null) {
            return null;
        }
        URI currentWrapperUri = uRI;
        String string = this.findStandardCustomBasePath(currentWrapperUri);
        if (string == null) {
            return null;
        }
        String customBasePath = string;
        URI baseUrl = new URI(currentWrapperUri.getScheme(), null, currentWrapperUri.getHost(), currentWrapperUri.getPort(), customBasePath, null, null);
        return this.gradleDistRepoDescriptor(StringsKt.endsWith$default((String)customBasePath, (String)this.repositoryName, (boolean)false, (int)2, null) ? this.repositoryName : "custom", baseUrl, "[module]-[revision](-[classifier])(.[ext])", this.wrapperCredentials(currentWrapperUri));
    }

    private final GradleDistRepoDescriptor gradleDistRepoDescriptor(String repoName, URI repoBaseUrl, String artifactPattern, WrapperCredentials credentials) {
        return new GradleDistRepoDescriptor(repoName, repoBaseUrl, artifactPattern, (Function1<? super AuthenticationSupported, Unit>)((Function1)arg_0 -> GradleDistRepoDescriptorLocator.gradleDistRepoDescriptor$lambda$0(credentials, arg_0)));
    }

    private static final Unit gradleDistRepoDescriptor$lambda$0(WrapperCredentials $credentials, AuthenticationSupported repo) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        if ($credentials != null) {
            Map.Entry usernameAndPassword = $credentials.usernameAndPassword();
            if (usernameAndPassword == null) {
                repo.credentials(HttpHeaderCredentials.class, new Action($credentials){
                    final /* synthetic */ WrapperCredentials $credentials;
                    {
                        this.$credentials = $credentials;
                    }

                    public final void execute(HttpHeaderCredentials $this$credentials) {
                        Intrinsics.checkNotNullParameter((Object)$this$credentials, (String)"$this$credentials");
                        Map.Entry entry = this.$credentials.authorizationHeader();
                        Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"authorizationHeader(...)");
                        Map.Entry header = entry;
                        $this$credentials.setName((String)header.getKey());
                        $this$credentials.setValue((String)header.getValue());
                    }
                });
            } else {
                repo.credentials(new Action(usernameAndPassword){
                    final /* synthetic */ Map.Entry<String, String> $usernameAndPassword;
                    {
                        this.$usernameAndPassword = $usernameAndPassword;
                    }

                    public final void execute(PasswordCredentials $this$credentials) {
                        Intrinsics.checkNotNullParameter((Object)$this$credentials, (String)"$this$credentials");
                        $this$credentials.setUsername(this.$usernameAndPassword.getKey());
                        $this$credentials.setPassword(this.$usernameAndPassword.getValue());
                    }
                });
            }
        }
        return Unit.INSTANCE;
    }
}

