/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformDependencyMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.ResolvableSelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.DefaultComponentOverrideMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.RejectedByAttributesVersion;
import org.gradle.internal.resolve.RejectedByRuleVersion;
import org.gradle.internal.resolve.RejectedBySelectorVersion;
import org.gradle.internal.resolve.RejectedVersion;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.result.ComponentIdResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableComponentIdResolveResult;
import org.gradle.util.internal.TextUtil;
import org.jspecify.annotations.Nullable;

class SelectorState
implements DependencyGraphSelector,
ResolvableSelectorState {
    private final DependencyState dependencyState;
    private final DependencyToComponentIdResolver resolver;
    private final ResolveState resolveState;
    private final ResolvedVersionConstraint versionConstraint;
    private final boolean versionByAncestor;
    private final boolean isProjectSelector;
    private final AttributeDesugaring attributeDesugaring;
    private @Nullable ComponentIdResolveResult preferResult;
    private @Nullable ComponentIdResolveResult requireResult;
    private @Nullable ModuleVersionResolveException failure;
    private ModuleResolveState targetModule;
    private boolean resolved;
    private boolean forced;
    private boolean softForced;
    private boolean fromLock;
    private boolean reusable;
    private boolean markedReusableAlready;
    private boolean changing;
    private int outgoingEdgeCount;

    SelectorState(DependencyState dependencyState, DependencyToComponentIdResolver resolver, ResolveState resolveState, ModuleIdentifier targetModuleId, boolean versionByAncestor) {
        this.resolver = resolver;
        this.resolveState = resolveState;
        this.targetModule = resolveState.getModule(targetModuleId);
        this.versionByAncestor = versionByAncestor;
        this.update(dependencyState);
        this.dependencyState = dependencyState;
        this.versionConstraint = versionByAncestor ? resolveState.resolveVersionConstraint(DefaultImmutableVersionConstraint.of()) : resolveState.resolveVersionConstraint(dependencyState.getDependency().getSelector());
        this.isProjectSelector = this.getSelector() instanceof ProjectComponentSelector;
        this.attributeDesugaring = resolveState.getAttributeDesugaring();
    }

    @Override
    public boolean isProject() {
        return this.isProjectSelector;
    }

    public void use(boolean deferSelection) {
        ++this.outgoingEdgeCount;
        if (this.outgoingEdgeCount == 1) {
            this.targetModule.addSelector(this, deferSelection);
        }
    }

    public void release() {
        --this.outgoingEdgeCount;
        assert (this.outgoingEdgeCount >= 0) : "Inconsistent selector state detected for '" + this + "': outgoing edge count cannot be negative";
        if (this.outgoingEdgeCount == 0) {
            this.removeAndMarkSelectorForReuse();
        }
    }

    private void removeAndMarkSelectorForReuse() {
        this.targetModule.removeSelector(this);
        this.resolved = false;
    }

    public String toString() {
        return this.dependencyState.getDependency().toString();
    }

    @Override
    public ComponentSelector getRequested() {
        return this.attributeDesugaring.desugarSelector(this.dependencyState.getRequested());
    }

    public ModuleResolveState getTargetModule() {
        return this.targetModule;
    }

    @Nullable ModuleVersionResolveException getFailure() {
        return this.failure;
    }

    @Override
    public ComponentIdResolveResult resolve(VersionSelector allRejects) {
        VersionSelector requiredSelector = this.versionConstraint == null ? null : this.versionConstraint.getRequiredSelector();
        this.requireResult = this.resolve(requiredSelector, allRejects, this.requireResult);
        return this.requireResult;
    }

    @Override
    public ComponentIdResolveResult resolvePrefer(VersionSelector allRejects) {
        if (this.versionConstraint == null || this.versionConstraint.getPreferredSelector() == null) {
            return null;
        }
        this.preferResult = this.resolve(this.versionConstraint.getPreferredSelector(), allRejects, this.preferResult);
        return this.preferResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentIdResolveResult resolve(@Nullable VersionSelector selector, VersionSelector rejector, ComponentIdResolveResult previousResult) {
        try {
            if (!this.requiresResolve(previousResult, rejector)) {
                ComponentIdResolveResult componentIdResolveResult = previousResult;
                return componentIdResolveResult;
            }
            DefaultBuildableComponentIdResolveResult idResolveResult = new DefaultBuildableComponentIdResolveResult();
            if (this.dependencyState.getSubstitutionFailure() != null) {
                idResolveResult.failed(this.dependencyState.getSubstitutionFailure());
            } else {
                IvyArtifactName firstArtifact = this.getFirstDependencyArtifact();
                ComponentOverrideMetadata overrideMetadata = DefaultComponentOverrideMetadata.forDependency(this.changing, firstArtifact);
                ImmutableAttributes requestAttributes = this.resolveState.getAttributesFactory().concat(this.resolveState.getConsumerAttributes(), this.targetModule.getMergedConstraintAttributes());
                this.resolver.resolve(this.dependencyState.getDependency().getSelector(), overrideMetadata, selector, rejector, idResolveResult, requestAttributes);
            }
            if (idResolveResult.getFailure() != null) {
                this.failure = idResolveResult.getFailure();
            }
            DefaultBuildableComponentIdResolveResult defaultBuildableComponentIdResolveResult = idResolveResult;
            return defaultBuildableComponentIdResolveResult;
        }
        finally {
            this.resolved = true;
        }
    }

    private boolean requiresResolve(@Nullable ComponentIdResolveResult previousResult, @Nullable VersionSelector allRejects) {
        this.reusable = false;
        if (previousResult == null) {
            return true;
        }
        if (previousResult.getFailure() != null) {
            return false;
        }
        if (previousResult.isRejected()) {
            return false;
        }
        return allRejects != null && allRejects.accept(previousResult.getModuleVersionId().getVersion());
    }

    @Override
    public void markResolved() {
        this.resolved = true;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    boolean markForReuse() {
        if (!this.resolved) {
            return true;
        }
        this.reusable = true;
        if (this.markedReusableAlready) {
            return true;
        }
        this.markedReusableAlready = true;
        return false;
    }

    boolean canAffectSelection() {
        if (this.reusable) {
            return true;
        }
        return !this.resolved;
    }

    public void overrideSelection(ComponentState selected) {
        this.resolved = true;
        this.reusable = false;
        this.targetModule = selected.getModule();
    }

    public boolean isVersionProvidedByAncestor() {
        return this.versionByAncestor;
    }

    public void visitSelectionReasons(Consumer<ComponentSelectionDescriptorInternal> visitor) {
        ComponentIdResolveResult result = this.getResult();
        if (result != null) {
            for (RejectedVersion rejectedVersion : result.getRejectedVersions()) {
                String version = rejectedVersion.getId().getVersion();
                if (rejectedVersion instanceof RejectedByRuleVersion) {
                    String reason = ((RejectedByRuleVersion)rejectedVersion).getReason();
                    visitor.accept(ComponentSelectionReasons.REJECTION.withDescription(new RejectedByRuleReason(version, reason)));
                    continue;
                }
                if (!(rejectedVersion instanceof RejectedByAttributesVersion)) continue;
                visitor.accept(ComponentSelectionReasons.REJECTION.withDescription(new RejectedByAttributesReason((RejectedByAttributesVersion)rejectedVersion)));
            }
        }
    }

    public ComponentSelectionDescriptorInternal maybeEnhanceReason(ComponentSelectionDescriptorInternal descriptor) {
        Set<String> unmatchedVersions;
        ComponentIdResolveResult result = this.getResult();
        if (result == null) {
            return descriptor;
        }
        Collection<RejectedVersion> rejectedVersions = result.getRejectedVersions();
        if (!rejectedVersions.isEmpty()) {
            ArrayList<String> rejectedBySelector = null;
            for (RejectedVersion rejectedVersion : rejectedVersions) {
                if (!(rejectedVersion instanceof RejectedBySelectorVersion)) continue;
                if (rejectedBySelector == null) {
                    rejectedBySelector = new ArrayList<String>(rejectedVersions.size());
                }
                rejectedBySelector.add(rejectedVersion.getId().getVersion());
            }
            if (rejectedBySelector != null) {
                return descriptor.withDescription(new RejectedBySelectorReason(rejectedBySelector, descriptor));
            }
        }
        if (!(unmatchedVersions = result.getUnmatchedVersions()).isEmpty()) {
            return descriptor.withDescription(new UnmatchedVersionsReason(unmatchedVersions, descriptor));
        }
        return descriptor;
    }

    private @Nullable ComponentIdResolveResult getResult() {
        if (this.preferResult == null) {
            return this.requireResult;
        }
        return this.preferResult;
    }

    public DependencyMetadata getDependencyMetadata() {
        return this.dependencyState.getDependency();
    }

    @Override
    public IvyArtifactName getFirstDependencyArtifact() {
        List<IvyArtifactName> artifacts = this.dependencyState.getDependency().getArtifacts();
        return artifacts.isEmpty() ? null : artifacts.get(0);
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public @Nullable ResolvedVersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    @Override
    public ComponentSelector getSelector() {
        return this.dependencyState.getDependency().getSelector();
    }

    @Override
    public boolean isForce() {
        return this.forced;
    }

    @Override
    public boolean isSoftForce() {
        return this.softForced;
    }

    @Override
    public boolean isFromLock() {
        return this.fromLock;
    }

    @Override
    public boolean hasStrongOpinion() {
        return this.forced || this.versionConstraint != null && this.versionConstraint.isStrict();
    }

    public void update(DependencyState dependencyState) {
        if (dependencyState != this.dependencyState) {
            if (!this.forced && dependencyState.isForced()) {
                this.forced = true;
                if (dependencyState.getDependency() instanceof LenientPlatformDependencyMetadata) {
                    this.softForced = true;
                    this.targetModule.resolveOptimizations.declareForcedPlatformInUse();
                }
                this.resolved = false;
            }
            if (!this.fromLock && dependencyState.isFromLock()) {
                this.fromLock = true;
                this.resolved = false;
            }
            this.changing = this.changing || dependencyState.getDependency().isChanging();
        }
    }

    private static class RejectedByRuleReason
    implements Describable {
        private final String version;
        private final String reason;

        private RejectedByRuleReason(String version, @Nullable String reason) {
            this.version = version;
            this.reason = reason;
        }

        public String getDisplayName() {
            return this.version + " by rule" + (this.reason != null ? " because " + this.reason : "");
        }
    }

    private static class RejectedByAttributesReason
    implements Describable {
        private final RejectedByAttributesVersion version;

        private RejectedByAttributesReason(RejectedByAttributesVersion version) {
            this.version = version;
        }

        public String getDisplayName() {
            TreeFormatter formatter = new TreeFormatter();
            this.version.describeTo(formatter);
            return "version " + formatter;
        }
    }

    private static class RejectedBySelectorReason
    implements Describable {
        private final List<String> rejectedVersions;
        private final ComponentSelectionDescriptorInternal descriptor;
        private final int hashCode;

        public RejectedBySelectorReason(List<String> rejectedVersions, ComponentSelectionDescriptorInternal descriptor) {
            this.rejectedVersions = rejectedVersions;
            this.descriptor = descriptor;
            this.hashCode = RejectedBySelectorReason.computeHashCode(descriptor, rejectedVersions);
        }

        public String getDisplayName() {
            boolean hasCustomDescription = this.descriptor.hasCustomDescription();
            StringBuilder sb = new StringBuilder(this.estimateSize(hasCustomDescription));
            sb.append("rejected version").append(TextUtil.getPluralEnding(this.rejectedVersions)).append(" ");
            Joiner.on((String)", ").appendTo(sb, this.rejectedVersions);
            if (hasCustomDescription) {
                sb.append(" because ").append(this.descriptor.getDescription());
            }
            return sb.toString();
        }

        private int estimateSize(boolean hasCustomDescription) {
            return 20 + this.rejectedVersions.size() * 8 + (hasCustomDescription ? 24 : 0);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RejectedBySelectorReason that = (RejectedBySelectorReason)o;
            return this.rejectedVersions.equals(that.rejectedVersions) && this.descriptor.equals(that.descriptor);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private static int computeHashCode(ComponentSelectionDescriptorInternal descriptor, List<String> rejectedVersions) {
            int result = rejectedVersions.hashCode();
            result = 31 * result + descriptor.hashCode();
            return result;
        }
    }

    private static class UnmatchedVersionsReason
    implements Describable {
        private final Set<String> rejectedVersions;
        private final ComponentSelectionDescriptorInternal descriptor;
        private final int hashCode;

        public UnmatchedVersionsReason(Set<String> rejectedVersions, ComponentSelectionDescriptorInternal descriptor) {
            this.rejectedVersions = rejectedVersions;
            this.descriptor = descriptor;
            this.hashCode = UnmatchedVersionsReason.computeHashCode(descriptor, rejectedVersions);
        }

        public String getDisplayName() {
            boolean hasCustomDescription = this.descriptor.hasCustomDescription();
            StringBuilder sb = new StringBuilder(this.estimateSize(hasCustomDescription));
            sb.append("didn't match version").append(TextUtil.getPluralEnding(this.rejectedVersions)).append(" ");
            Joiner.on((String)", ").appendTo(sb, this.rejectedVersions);
            if (hasCustomDescription) {
                sb.append(" because ").append(this.descriptor.getDescription());
            }
            return sb.toString();
        }

        private int estimateSize(boolean hasCustomDescription) {
            return 24 + this.rejectedVersions.size() * 8 + (hasCustomDescription ? 24 : 0);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnmatchedVersionsReason that = (UnmatchedVersionsReason)o;
            return this.rejectedVersions.equals(that.rejectedVersions) && this.descriptor.equals(that.descriptor);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private static int computeHashCode(ComponentSelectionDescriptorInternal descriptor, Set<String> rejectedVersions) {
            int result = rejectedVersions.hashCode();
            result = 31 * result + descriptor.hashCode();
            return result;
        }
    }
}

