/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.artifacts.configurations.ExtendedConfiguration;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;

class ExtendedConfigurations {
    private final Consumer<Configuration> validationAction;
    private final ProviderFactory providerFactory;
    private final Set<ExtendedConfiguration> configurations = new LinkedHashSet<ExtendedConfiguration>();

    public ExtendedConfigurations(Consumer<Configuration> validationAction, ProviderFactory providerFactory) {
        this.validationAction = validationAction;
        this.providerFactory = providerFactory;
    }

    public void add(Configuration configuration) {
        this.validationAction.accept(configuration);
        this.configurations.add(new RealizedExtendedConfiguration(configuration, this.providerFactory));
    }

    public void add(Provider<? extends Configuration> configurationProvider) {
        this.configurations.add(new ProvidedExtendedConfiguration(configurationProvider, this.validationAction, this.providerFactory));
    }

    public boolean isEmpty() {
        return this.configurations.isEmpty();
    }

    public void visitConfigurations(ExtendedConfiguration.Visitor visitor) {
        this.configurations.forEach(visitor::visit);
    }

    private static class RealizedExtendedConfiguration
    implements ExtendedConfiguration {
        private final Configuration configuration;
        private final ProviderFactory providerFactory;

        RealizedExtendedConfiguration(Configuration configuration, ProviderFactory providerFactory) {
            this.configuration = configuration;
            this.providerFactory = providerFactory;
        }

        @Override
        public Configuration get() {
            return this.configuration;
        }

        @Override
        public <T> Provider<DomainObjectCollection<? extends T>> mapToCollection(Function<Configuration, DomainObjectCollection<T>> configurationToCollection) {
            return this.providerFactory.provider(() -> (DomainObjectCollection)configurationToCollection.apply(this.configuration));
        }
    }

    private static class ProvidedExtendedConfiguration
    implements ExtendedConfiguration {
        private final Provider<? extends Configuration> provider;
        private final Consumer<Configuration> validationAction;
        private final ProviderFactory providerFactory;

        ProvidedExtendedConfiguration(Provider<? extends Configuration> provider, Consumer<Configuration> validationAction, ProviderFactory providerFactory) {
            this.provider = provider;
            this.validationAction = validationAction;
            this.providerFactory = providerFactory;
        }

        @Override
        public Configuration get() {
            Configuration configuration = (Configuration)this.provider.get();
            this.validationAction.accept(configuration);
            return configuration;
        }

        @Override
        public <T> Provider<DomainObjectCollection<? extends T>> mapToCollection(Function<Configuration, DomainObjectCollection<T>> configurationToCollection) {
            return this.providerFactory.provider(() -> (DomainObjectCollection)configurationToCollection.apply(this.get()));
        }
    }
}

