/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.internal.Cast;
import org.gradle.internal.service.DefaultServiceLocator;
import org.gradle.internal.service.ServiceLocator;
import org.gradle.internal.service.UnknownServiceException;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jspecify.annotations.Nullable;

@ServiceScope(value={Scope.Global.class})
public class CachingServiceLocator
implements ServiceLocator {
    private final ServiceLocator delegate;
    private final Map<Class<?>,  @Nullable DefaultServiceLocator.ServiceFactory<?>> serviceFactories = new HashMap();
    private final Map<Class<?>, Object> services = new HashMap();
    private final Map<Class<?>, List<?>> allServices = new HashMap();

    public static CachingServiceLocator of(ServiceLocator other) {
        return new CachingServiceLocator(other);
    }

    private CachingServiceLocator(ServiceLocator delegate) {
        this.delegate = delegate;
    }

    @Override
    public synchronized <T>  @Nullable DefaultServiceLocator.ServiceFactory<T> findFactory(Class<T> serviceType) {
        return (DefaultServiceLocator.ServiceFactory)Cast.uncheckedCast((Object)this.serviceFactories.computeIfAbsent(serviceType, this.delegate::findFactory));
    }

    @Override
    public synchronized <T> T get(Class<T> serviceType) throws UnknownServiceException {
        return (T)Cast.uncheckedNonnullCast((Object)this.services.computeIfAbsent(serviceType, this.delegate::get));
    }

    @Override
    public synchronized <T> List<T> getAll(Class<T> serviceType) throws UnknownServiceException {
        return (List)Cast.uncheckedNonnullCast((Object)this.allServices.computeIfAbsent(serviceType, this.delegate::getAll));
    }

    @Override
    public synchronized <T> DefaultServiceLocator.ServiceFactory<T> getFactory(Class<T> serviceType) throws UnknownServiceException {
        DefaultServiceLocator.ServiceFactory<T> factory = this.findFactory(serviceType);
        if (factory == null) {
            throw new UnknownServiceException(serviceType, String.format("Could not find meta-data resource 'META-INF/services/%s' for service '%s'.", serviceType.getName(), serviceType.getName()));
        }
        return factory;
    }
}

