/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gradle.StartParameter;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.GradleException;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.execution.EntryTaskSelector;
import org.gradle.internal.Describables;
import org.gradle.internal.RunDefaultTasksExecutionRequest;
import org.gradle.internal.Try;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.buildtree.BuildTreeFinishExecutor;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.buildtree.BuildTreeModelAction;
import org.gradle.internal.buildtree.BuildTreeModelCreator;
import org.gradle.internal.buildtree.BuildTreeWorkController;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.WorkTypeAware;
import org.gradle.internal.model.StateTransitionController;
import org.gradle.internal.model.StateTransitionControllerFactory;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

public class DefaultBuildTreeLifecycleController
implements BuildTreeLifecycleController {
    private final BuildLifecycleController buildLifecycleController;
    private final BuildTreeWorkController workController;
    private final BuildTreeModelCreator modelCreator;
    private final BuildTreeFinishExecutor finishExecutor;
    private final StateTransitionController<State> state;
    private final StartParameter startParameter;
    private final BuildModelParameters buildModelParameters;

    public DefaultBuildTreeLifecycleController(BuildLifecycleController buildLifecycleController, BuildTreeWorkController workController, BuildTreeModelCreator modelCreator, BuildTreeFinishExecutor finishExecutor, StateTransitionControllerFactory controllerFactory, StartParameter startParameter, BuildModelParameters buildModelParameters) {
        this.buildLifecycleController = buildLifecycleController;
        this.workController = workController;
        this.modelCreator = modelCreator;
        this.finishExecutor = finishExecutor;
        this.state = controllerFactory.newController(Describables.of((Object)"build tree state"), State.NotStarted);
        this.startParameter = startParameter;
        this.buildModelParameters = buildModelParameters;
    }

    @Override
    public void beforeBuild(Consumer<? super GradleInternal> action) {
        this.state.inState(State.NotStarted, () -> action.accept(this.buildLifecycleController.getGradle()));
    }

    @Override
    public void scheduleAndRunTasks() {
        this.scheduleAndRunTasks(null);
    }

    @Override
    public void scheduleAndRunTasks(@Nullable EntryTaskSelector selector) {
        this.runBuild(() -> this.workController.scheduleAndRunRequestedTasks(selector).getExecutionResultOrThrow());
    }

    @Override
    public <T> T fromBuildModel(boolean runTasks, BuildTreeModelAction<? extends T> action) {
        return this.runBuild(() -> {
            this.modelCreator.beforeTasks(action);
            ExecutionResult<Void> taskRunResult = ExecutionResult.succeeded();
            if (runTasks && this.isEligibleToRunTasks().booleanValue()) {
                taskRunResult = this.runTasks();
            }
            ExecutionResult modelResult = this.runFromBuildModel(action);
            return modelResult.withFailures(taskRunResult);
        });
    }

    private <T> ExecutionResult<T> runFromBuildModel(BuildTreeModelAction<? extends T> action) {
        Try model = Try.ofFailable(() -> this.modelCreator.fromBuildModel(action));
        return model.getFailure().isPresent() ? ExecutionResult.failed((Throwable)((Object)BuildActionExecutionException.wrap((Throwable)model.getFailure().get()))) : ExecutionResult.succeeded(model.get());
    }

    private ExecutionResult<Void> runTasks() {
        BuildTreeWorkController.TaskRunResult result = this.workController.scheduleAndRunRequestedTasks(null);
        if (!result.getScheduleResult().isSuccessful()) {
            return result.getScheduleResult();
        }
        return result.getExecutionResultOrThrow();
    }

    @Override
    public <T> T withEmptyBuild(Function<? super SettingsInternal, T> action) {
        return this.runBuild(() -> {
            Object result = this.buildLifecycleController.withSettings(action);
            return ExecutionResult.succeeded(result);
        });
    }

    private Boolean isEligibleToRunTasks() {
        boolean isIsolatedProjectsEnabled = this.buildModelParameters.isIsolatedProjects();
        boolean isDefaultTasksRequested = this.startParameter.getTaskRequests().size() == 1 && this.startParameter.getTaskRequests().get(0) instanceof RunDefaultTasksExecutionRequest;
        boolean isHelpTaskOnly = this.startParameter.getTaskRequests().size() == 1 && ((TaskExecutionRequest)this.startParameter.getTaskRequests().get(0)).getArgs().contains("help");
        return !isIsolatedProjectsEnabled || !isDefaultTasksRequested && !isHelpTaskOnly;
    }

    private <T> T runBuild(Supplier<ExecutionResult<? extends T>> action) {
        return (T)this.state.transition(State.NotStarted, State.Complete, () -> {
            ExecutionResult result;
            try {
                result = (ExecutionResult)action.get();
            }
            catch (Throwable t) {
                result = ExecutionResult.failed(t);
            }
            RuntimeException finalReportableFailure = this.finishExecutor.finishBuildTree(result.getFailures());
            if (finalReportableFailure != null) {
                throw finalReportableFailure;
            }
            return result.getValue();
        });
    }

    private static enum State implements StateTransitionController.State
    {
        NotStarted,
        Complete;

    }

    @NullMarked
    @Contextual
    @VisibleForTesting
    static class BuildActionExecutionException
    extends GradleException
    implements WorkTypeAware {
        private BuildActionExecutionException(Throwable cause) {
            super(cause.getMessage(), cause);
        }

        @Override
        public String getWorkType() {
            return "BuildAction";
        }

        public static BuildActionExecutionException wrap(Throwable throwable) {
            return new BuildActionExecutionException(throwable);
        }
    }
}

