/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.software.internal;

import groovy.lang.Closure;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.plugin.software.internal.ProjectFeatureApplicator;
import org.gradle.plugin.software.internal.ProjectFeatureDeclarations;
import org.gradle.plugin.software.internal.ProjectFeatureImplementation;
import org.gradle.plugin.software.internal.ProjectFeatureSupportInternal;
import org.gradle.plugin.software.internal.TargetTypeInformationChecks;
import org.gradle.util.internal.ConfigureUtil;
import org.jspecify.annotations.Nullable;

public abstract class ProjectFeaturesDynamicObject
extends AbstractDynamicObject {
    private final DynamicObjectAware target;
    private final ProjectFeatureSupportInternal.ProjectFeatureDefinitionContext context;
    public static final String CONTEXT_METHOD_NAME = "$.projectFeatureContext";

    @Inject
    public ProjectFeaturesDynamicObject(DynamicObjectAware target, ProjectFeatureSupportInternal.ProjectFeatureDefinitionContext context) {
        this.target = target;
        this.context = context;
    }

    public String getDisplayName() {
        return "project features";
    }

    public boolean hasMethod(String name, Object ... arguments) {
        return this.isFeatureConfigureMethod(name, arguments);
    }

    private boolean isFeatureConfigureMethod(String name, @Nullable Object[] arguments) {
        if (arguments == null || arguments.length != 1 || !(arguments[0] instanceof Closure)) {
            return false;
        }
        Set<ProjectFeatureImplementation<?, ?>> candidateFeatures = this.getProjectFeatureRegistry().getProjectFeatureImplementations().get(name);
        if (candidateFeatures == null) {
            return false;
        }
        return candidateFeatures.stream().anyMatch(feature -> TargetTypeInformationChecks.isValidBindingType(feature.getTargetDefinitionType(), this.target.getClass()));
    }

    public DynamicInvokeResult tryInvokeMethod(String name, Object ... arguments) {
        if (name.equals(CONTEXT_METHOD_NAME) && arguments.length == 0) {
            return DynamicInvokeResult.found((Object)this.context);
        }
        if (this.isFeatureConfigureMethod(name, arguments)) {
            Set<ProjectFeatureImplementation<?, ?>> candidateFeatures = this.getProjectFeatureRegistry().getProjectFeatureImplementations().get(name);
            if (candidateFeatures == null) {
                return DynamicInvokeResult.notFound();
            }
            Set matchingFeatures = candidateFeatures.stream().filter(feature -> TargetTypeInformationChecks.isValidBindingType(feature.getTargetDefinitionType(), this.target.getClass())).collect(Collectors.toSet());
            if (matchingFeatures.isEmpty()) {
                return DynamicInvokeResult.notFound();
            }
            if (matchingFeatures.size() > 1) {
                throw new IllegalStateException(String.format("Multiple project features of name '%s' match target type '%s'. Cannot disambiguate.", name, this.target.getClass().getName()));
            }
            Object projectFeatureConfigurationModel = this.getProjectFeatureApplicator().applyFeatureTo(this.target, (ProjectFeatureImplementation)matchingFeatures.iterator().next());
            return DynamicInvokeResult.found((Object)ConfigureUtil.configure((Closure)((Closure)arguments[0]), projectFeatureConfigurationModel));
        }
        return DynamicInvokeResult.notFound();
    }

    @Inject
    protected abstract ProjectFeatureDeclarations getProjectFeatureRegistry();

    @Inject
    protected abstract ProjectFeatureApplicator getProjectFeatureApplicator();
}

