/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ServiceScope(value={Scope.BuildSession.class})
public final class JvmInstallationProblemReporter {
    private final Set<ProblemReport> reportedProblems = Sets.newConcurrentHashSet();

    public void reportProblemIfNeeded(Logger targetLogger, InstallationLocation installationLocation, String message) {
        ProblemReport key = new ProblemReport(installationLocation.isAutoDetected(), message);
        if (!this.reportedProblems.add(key)) {
            return;
        }
        targetLogger.log(key.autoDetected ? LogLevel.INFO : LogLevel.WARN, message);
    }

    private static final class ProblemReport {
        private final boolean autoDetected;
        private final String problem;

        private ProblemReport(boolean autoDetected, String problem) {
            this.autoDetected = autoDetected;
            this.problem = problem;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProblemReport that = (ProblemReport)o;
            return this.autoDetected == that.autoDetected && Objects.equals(this.problem, that.problem);
        }

        public int hashCode() {
            return Objects.hash(this.autoDetected, this.problem);
        }

        public String toString() {
            return "ProblemReport{autoDetected=" + this.autoDetected + ", problem='" + this.problem + "'}";
        }
    }
}

