/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import org.gradle.internal.execution.Identity;
import org.gradle.internal.execution.MutableUnitOfWork;
import org.gradle.internal.execution.history.PreviousExecutionState;
import org.gradle.internal.execution.steps.AfterExecutionResult;
import org.gradle.internal.execution.steps.IdentityContext;
import org.gradle.internal.execution.steps.MutableStep;
import org.gradle.internal.execution.steps.PreviousExecutionContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.WorkspaceContext;

public class LoadPreviousExecutionStateStep<C extends WorkspaceContext, R extends AfterExecutionResult>
extends MutableStep<C, R> {
    private final Step<? super PreviousExecutionContext, ? extends R> delegate;

    public LoadPreviousExecutionStateStep(Step<? super PreviousExecutionContext, ? extends R> delegate) {
        this.delegate = delegate;
    }

    @Override
    protected R executeMutable(MutableUnitOfWork work, C context) {
        Identity identity = ((IdentityContext)context).getIdentity();
        PreviousExecutionState previousExecutionState = work.getHistory().flatMap(history -> history.load(identity.getUniqueId())).orElse(null);
        AfterExecutionResult result = (AfterExecutionResult)this.delegate.execute(work, new PreviousExecutionContext((WorkspaceContext)context, previousExecutionState));
        work.getHistory().ifPresent(history -> {
            if (!result.getAfterExecutionOutputState().isPresent()) {
                history.remove(context.getIdentity().getUniqueId());
            }
        });
        return (R)result;
    }
}

