/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testfixtures.internal;

import java.io.File;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.CleanableStore;
import org.gradle.cache.FineGrainedCacheCleanupStrategy;
import org.gradle.cache.FineGrainedPersistentCache;
import org.gradle.cache.IndexedCache;
import org.gradle.cache.IndexedCacheParameters;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CacheFactory;
import org.gradle.cache.internal.CacheVisitor;
import org.gradle.internal.Cast;
import org.gradle.internal.Pair;
import org.gradle.internal.serialize.Serializer;
import org.gradle.testfixtures.internal.TestInMemoryIndexedCache;
import org.gradle.util.internal.GFileUtils;
import org.jspecify.annotations.Nullable;

public class TestInMemoryCacheFactory
implements CacheFactory {
    final Map<Pair<File, String>, IndexedCache<?, ?>> caches = Collections.synchronizedMap(new LinkedHashMap());

    public PersistentCache open(File cacheDir, String displayName, Map<String, ?> properties, LockOptions lockOptions, @Nullable Consumer<? super PersistentCache> initializer, @Nullable CacheCleanupStrategy cacheCleanupStrategy) throws CacheOpenException {
        GFileUtils.mkdirs((File)cacheDir);
        InMemoryCache cache = new InMemoryCache(cacheDir, displayName, cacheCleanupStrategy != null ? cacheCleanupStrategy : CacheCleanupStrategy.NO_CLEANUP);
        if (initializer != null) {
            initializer.accept(cache);
        }
        return cache;
    }

    public FineGrainedPersistentCache openFineGrained(File cacheDir, String displayName, FineGrainedCacheCleanupStrategy cacheCleanupStrategy) throws CacheOpenException {
        GFileUtils.mkdirs((File)cacheDir);
        return new InMemoryFineGrainedCache(cacheDir, displayName, cacheCleanupStrategy != null ? cacheCleanupStrategy.getCleanupStrategy() : CacheCleanupStrategy.NO_CLEANUP);
    }

    public PersistentCache open(File cacheDir, String displayName) {
        return new InMemoryCache(cacheDir, displayName, CacheCleanupStrategy.NO_CLEANUP);
    }

    public void visitCaches(CacheVisitor visitor) {
        throw new UnsupportedOperationException();
    }

    private class InMemoryCache
    implements PersistentCache {
        private final File cacheDir;
        private final String displayName;
        private boolean closed;
        private final CacheCleanupStrategy cleanup;

        public InMemoryCache(File cacheDir, String displayName, CacheCleanupStrategy cleanup) {
            this.cacheDir = cacheDir;
            this.displayName = displayName;
            this.cleanup = cleanup;
        }

        public void close() {
            this.cleanup();
            this.closed = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanup() {
            if (this.cleanup != null) {
                InMemoryCache inMemoryCache = this;
                synchronized (inMemoryCache) {
                    this.cleanup.clean((CleanableStore)this, Instant.now());
                }
            }
        }

        public File getBaseDir() {
            return this.cacheDir;
        }

        public Collection<File> getReservedCacheFiles() {
            return Collections.emptyList();
        }

        private void assertNotClosed() {
            if (this.closed) {
                throw new IllegalStateException("cache is closed");
            }
        }

        public <K, V> IndexedCache<K, V> createIndexedCache(String name, Class<K> keyType, Serializer<V> valueSerializer) {
            this.assertNotClosed();
            return this.createIndexedCache(name, valueSerializer);
        }

        public <K, V> boolean indexedCacheExists(IndexedCacheParameters<K, V> parameters) {
            return true;
        }

        public <K, V> IndexedCache<K, V> createIndexedCache(IndexedCacheParameters<K, V> parameters) {
            this.assertNotClosed();
            return this.createIndexedCache(parameters.getCacheName(), parameters.getValueSerializer());
        }

        private <K, V> IndexedCache<K, V> createIndexedCache(String name, Serializer<V> valueSerializer) {
            this.assertNotClosed();
            IndexedCache<?, ?> indexedCache = TestInMemoryCacheFactory.this.caches.get(Pair.of((Object)this.cacheDir, (Object)name));
            if (indexedCache == null) {
                indexedCache = new TestInMemoryIndexedCache(valueSerializer);
                TestInMemoryCacheFactory.this.caches.put((Pair<File, String>)Pair.of((Object)this.cacheDir, (Object)name), indexedCache);
            }
            return (IndexedCache)Cast.uncheckedCast(indexedCache);
        }

        public <T> T withFileLock(Supplier<? extends T> action) {
            return action.get();
        }

        public void withFileLock(Runnable action) {
            action.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T useCache(Supplier<? extends T> action) {
            this.assertNotClosed();
            InMemoryCache inMemoryCache = this;
            synchronized (inMemoryCache) {
                return action.get();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void useCache(Runnable action) {
            this.assertNotClosed();
            InMemoryCache inMemoryCache = this;
            synchronized (inMemoryCache) {
                action.run();
            }
        }

        public String getDisplayName() {
            return "InMemoryCache '" + this.displayName + "' " + this.cacheDir;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    private static class InMemoryFineGrainedCache
    implements FineGrainedPersistentCache {
        private final File cacheDir;
        private final String displayName;
        private final CacheCleanupStrategy cleanupStrategy;
        private boolean closed;

        public InMemoryFineGrainedCache(File cacheDir, String displayName, CacheCleanupStrategy cleanupStrategy) {
            this.cacheDir = cacheDir;
            this.displayName = displayName;
            this.cleanupStrategy = cleanupStrategy;
        }

        public FineGrainedPersistentCache open() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T useCache(String key, Supplier<? extends T> action) {
            this.assertNotClosed();
            InMemoryFineGrainedCache.validateKey(key);
            InMemoryFineGrainedCache inMemoryFineGrainedCache = this;
            synchronized (inMemoryFineGrainedCache) {
                return action.get();
            }
        }

        public void useCache(String key, Runnable action) {
            this.useCache(key, () -> {
                action.run();
                return null;
            });
        }

        public <T> T withFileLock(String key, Supplier<? extends T> action) {
            this.assertNotClosed();
            InMemoryFineGrainedCache.validateKey(key);
            return action.get();
        }

        public void withFileLock(String key, Runnable action) {
            this.withFileLock(key, () -> {
                action.run();
                return null;
            });
        }

        private void assertNotClosed() {
            if (this.closed) {
                throw new IllegalStateException("cache is closed");
            }
        }

        public void close() {
            this.cleanup();
            this.closed = true;
        }

        public File getBaseDir() {
            return this.cacheDir;
        }

        public Collection<File> getReservedCacheFiles() {
            return Collections.emptyList();
        }

        public String getDisplayName() {
            return "InMemoryFineGrainedCache '" + this.displayName + "' " + this.cacheDir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanup() {
            InMemoryFineGrainedCache inMemoryFineGrainedCache = this;
            synchronized (inMemoryFineGrainedCache) {
                this.cleanupStrategy.clean((CleanableStore)this, Instant.now());
            }
        }

        public String toString() {
            return this.getDisplayName();
        }

        private static void validateKey(String key) {
            if (key.contains("/") || key.contains("\\")) {
                throw new IllegalArgumentException(String.format("Cache key path must not contain file separator: '%s'", key));
            }
            if (key.startsWith(".")) {
                throw new IllegalArgumentException(String.format("Cache key must not start with '.' character: '%s'", key));
            }
        }
    }
}

