/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal.services;

import java.util.Map;
import java.util.Properties;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.initialization.JvmToolchainsConfigurationValidator;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;

public class DefaultJvmToolchainsConfigurationValidator
implements JvmToolchainsConfigurationValidator {
    private final StartParameterInternal startParameter;

    public DefaultJvmToolchainsConfigurationValidator(StartParameterInternal startParameter) {
        this.startParameter = startParameter;
    }

    public void validatePropertyConfiguration(String propertyName) {
        Map projectProperties = this.startParameter.getProjectPropertiesUntracked();
        if (projectProperties.containsKey(propertyName)) {
            String projectProperty = (String)projectProperties.get(propertyName);
            Properties systemProperties = System.getProperties();
            if (systemProperties.containsKey(propertyName)) {
                Object systemProperty = systemProperties.get(propertyName);
                if (!projectProperty.equals(systemProperty)) {
                    throw new InvalidUserDataException("The Gradle property '" + propertyName + "' (set to '" + systemProperty + "') has a different value than the project property '" + propertyName + "' (set to '" + projectProperty + "'). Please set them to the same value or only set the Gradle property.");
                }
            } else {
                DefaultJvmToolchainsConfigurationValidator.emitDeprecatedWarning(propertyName, projectProperty);
            }
        }
    }

    public void validateAllPropertiesConfigurationsForDaemonJvmToolchains() {
        if (this.startParameter.isDaemonJvmCriteriaConfigured()) {
            this.validatePropertyConfiguration("org.gradle.java.installations.fromEnv");
            this.validatePropertyConfiguration("org.gradle.java.installations.paths");
            this.validatePropertyConfiguration("org.gradle.java.installations.auto-detect");
            this.validatePropertyConfiguration("org.gradle.java.installations.auto-download");
            this.validatePropertyConfiguration("org.gradle.java.installations.idea-jdks-directory");
        }
    }

    private static void emitDeprecatedWarning(String propertyName, String value) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateAction)DeprecationLogger.deprecateAction((String)("Specifying '" + propertyName + "' as a project property on the command line")).withAdvice("Instead, specify it as a Gradle property: '-D" + propertyName + "=" + value + "'.")).willBeRemovedInGradle10().withUpgradeGuideSection(9, "toolchain-project-properties")).nagUser();
    }
}

