/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.ExecutionOutputState;
import org.gradle.internal.execution.history.impl.OutputSnapshotUtil;
import org.gradle.internal.execution.steps.AfterExecutionOutputFilter;
import org.gradle.internal.execution.steps.MutableBeforeExecutionContext;
import org.gradle.internal.snapshot.FileSystemSnapshot;

public class OverlappingOutputsFilter
implements AfterExecutionOutputFilter<MutableBeforeExecutionContext> {
    @Override
    public ImmutableSortedMap<String, FileSystemSnapshot> filterOutputs(MutableBeforeExecutionContext context, ImmutableSortedMap<String, FileSystemSnapshot> unfilteredOutputSnapshotsAfterExecution) {
        if (context.getDetectedOverlappingOutputs().isPresent()) {
            ImmutableSortedMap previousExecutionOutputSnapshots = context.getPreviousExecutionState().map(ExecutionOutputState::getOutputFilesProducedByWork).orElse(ImmutableSortedMap.of());
            ImmutableSortedMap unfilteredOutputSnapshotsBeforeExecution = context.getBeforeExecutionState().map(BeforeExecutionState::getOutputFileLocationSnapshots).orElse(ImmutableSortedMap.of());
            return OutputSnapshotUtil.filterOutputsAfterExecution((ImmutableSortedMap<String, FileSystemSnapshot>)previousExecutionOutputSnapshots, (ImmutableSortedMap<String, FileSystemSnapshot>)unfilteredOutputSnapshotsBeforeExecution, unfilteredOutputSnapshotsAfterExecution);
        }
        return unfilteredOutputSnapshotsAfterExecution;
    }
}

