/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.service.BuildCacheLoadResult;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Try;
import org.gradle.internal.execution.Execution;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.OutputVisitor;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.impl.DefaultExecutionOutputState;
import org.gradle.internal.execution.steps.AfterExecutionResult;
import org.gradle.internal.execution.steps.CachingContext;
import org.gradle.internal.execution.steps.IdentityContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.WorkspaceContext;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.vfs.FileSystemAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildCacheStep<C extends WorkspaceContext>
implements Step<C, AfterExecutionResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildCacheStep.class);
    private final BuildCacheController buildCache;
    private final Deleter deleter;
    private final FileSystemAccess fileSystemAccess;
    private final OutputChangeListener outputChangeListener;
    private final Step<? super C, ? extends AfterExecutionResult> delegate;

    public BuildCacheStep(BuildCacheController buildCache, Deleter deleter, FileSystemAccess fileSystemAccess, OutputChangeListener outputChangeListener, Step<? super C, ? extends AfterExecutionResult> delegate) {
        this.buildCache = buildCache;
        this.deleter = deleter;
        this.fileSystemAccess = fileSystemAccess;
        this.outputChangeListener = outputChangeListener;
        this.delegate = delegate;
    }

    @Override
    public AfterExecutionResult execute(UnitOfWork work, C context) {
        return ((CachingContext)context).getCachingState().fold(cachingEnabled -> this.executeWithCache(work, context, cachingEnabled.getCacheKeyCalculatedState().getKey()), cachingDisabled -> this.executeWithoutCache(work, context));
    }

    private AfterExecutionResult executeWithCache(UnitOfWork work, C context, BuildCacheKey cacheKey) {
        CacheableWork cacheableWork = new CacheableWork(((IdentityContext)context).getIdentity().getUniqueId(), ((WorkspaceContext)context).getWorkspace(), work);
        return (AfterExecutionResult)Try.ofFailable(() -> work.isAllowedToLoadFromCache() ? this.tryLoadingFromCache(cacheKey, cacheableWork) : Optional.empty()).map(successfulLoad -> successfulLoad.map(cacheHit -> {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Loaded cache entry for {} with cache key {}", (Object)work.getDisplayName(), (Object)cacheKey.getHashCode());
            }
            this.cleanLocalState(context.getWorkspace(), work);
            OriginMetadata originMetadata = cacheHit.getOriginMetadata();
            Try execution = Try.successful((Object)Execution.skipped(Execution.ExecutionOutcome.FROM_CACHE, work));
            DefaultExecutionOutputState afterExecutionOutputState = new DefaultExecutionOutputState(true, (ImmutableSortedMap<String, FileSystemSnapshot>)cacheHit.getResultingSnapshots(), originMetadata, true);
            afterExecutionOutputState.getOutputFilesProducedByWork().values().stream().flatMap(FileSystemSnapshot::roots).forEach(arg_0 -> ((FileSystemAccess)this.fileSystemAccess).record(arg_0));
            return new AfterExecutionResult(originMetadata.getExecutionTime(), (Try<Execution>)execution, afterExecutionOutputState);
        }).orElseGet(() -> this.executeAndStoreInCache(cacheableWork, cacheKey, context))).getOrMapFailure(loadFailure -> new AfterExecutionResult(Duration.ZERO, (Try<Execution>)Try.failure((Throwable)new RuntimeException(String.format("Failed to load cache entry %s for %s: %s", cacheKey.getHashCode(), work.getDisplayName(), loadFailure.getMessage()), (Throwable)loadFailure)), null));
    }

    private Optional<BuildCacheLoadResult> tryLoadingFromCache(BuildCacheKey cacheKey, CacheableWork cacheableWork) {
        List<String> cacheableLocations = cacheableWork.work.getCachedOutputLocationsForInvalidation(cacheableWork.workspace);
        this.fileSystemAccess.invalidate(cacheableLocations);
        return this.buildCache.load(cacheKey, (CacheableEntity)cacheableWork);
    }

    private void cleanLocalState(File workspace, final UnitOfWork work) {
        work.visitOutputs(workspace, new OutputVisitor(){

            @Override
            public void visitLocalState(File localStateRoot) {
                try {
                    BuildCacheStep.this.outputChangeListener.invalidateCachesFor((Iterable<String>)ImmutableList.of((Object)localStateRoot.getAbsolutePath()));
                    BuildCacheStep.this.deleter.deleteRecursively(localStateRoot);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(String.format("Failed to clean up local state files for %s: %s", work.getDisplayName(), localStateRoot), ex);
                }
            }
        });
    }

    private AfterExecutionResult executeAndStoreInCache(CacheableWork cacheableWork, BuildCacheKey cacheKey, C context) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Did not find cache entry for {} with cache key {}, executing instead", (Object)cacheableWork.getDisplayName(), (Object)cacheKey.getHashCode());
        }
        AfterExecutionResult result = this.executeWithoutCache(cacheableWork.work, context);
        try {
            result.getExecution().ifSuccessfulOrElse(executionResult -> this.storeInCacheUnlessDisabled(cacheableWork, cacheKey, result, (Execution)executionResult), failure -> LOGGER.debug("Not storing result of {} in cache because the execution failed", (Object)cacheableWork.getDisplayName()));
            return result;
        }
        catch (Exception storeFailure) {
            return new AfterExecutionResult(Result.failed(storeFailure, result.getDuration()), result.getAfterExecutionOutputState().orElse(null));
        }
    }

    private void storeInCacheUnlessDisabled(CacheableWork cacheableWork, BuildCacheKey cacheKey, AfterExecutionResult result, Execution executionResult) {
        if (executionResult.canStoreOutputsInCache()) {
            result.getAfterExecutionOutputState().ifPresent(afterExecutionState -> this.store(cacheableWork, cacheKey, afterExecutionState.getOutputFilesProducedByWork(), afterExecutionState.getOriginMetadata().getExecutionTime()));
        } else {
            LOGGER.debug("Not storing result of {} in cache because storing was disabled for this execution", (Object)cacheableWork.getDisplayName());
        }
    }

    private void store(CacheableWork work, BuildCacheKey cacheKey, ImmutableSortedMap<String, FileSystemSnapshot> outputFilesProducedByWork, Duration executionTime) {
        try {
            this.buildCache.store(cacheKey, (CacheableEntity)work, outputFilesProducedByWork, executionTime);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Stored cache entry for {} with cache key {}", (Object)work.getDisplayName(), (Object)cacheKey.getHashCode());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to store cache entry %s for %s: %s", cacheKey.getHashCode(), work.getDisplayName(), e.getMessage()), e);
        }
    }

    private AfterExecutionResult executeWithoutCache(UnitOfWork work, C context) {
        return this.delegate.execute(work, context);
    }

    private static class CacheableWork
    implements CacheableEntity {
        private final String identity;
        private final File workspace;
        private final UnitOfWork work;

        public CacheableWork(String identity, File workspace, UnitOfWork work) {
            this.identity = identity;
            this.workspace = workspace;
            this.work = work;
        }

        public String getIdentity() {
            return this.identity;
        }

        public Class<?> getType() {
            return this.work.getClass();
        }

        public String getDisplayName() {
            return this.work.getDisplayName();
        }

        public void visitOutputTrees(final CacheableEntity.CacheableTreeVisitor visitor) {
            this.work.visitOutputs(this.workspace, new OutputVisitor(){

                @Override
                public void visitOutputProperty(String propertyName, TreeType type, OutputVisitor.OutputFileValueSupplier value) {
                    visitor.visitOutputTree(propertyName, type, value.getValue());
                }
            });
        }
    }
}

