/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.collect;

import org.gradle.internal.collect.ArrayCopy;
import org.gradle.internal.collect.ChampNode;
import org.gradle.internal.collect.HashCollisionNode;

final class ChampDeletion {
    ChampDeletion() {
    }

    static <K> ChampNode<K> deleteFrom(ChampNode<K> trie, K key, int hash, int shift, int payload) {
        int nodeMap = trie.nodeMap;
        int mask = ChampNode.mask(hash, shift);
        int bit = 1 << mask;
        if ((nodeMap & bit) == bit) {
            Object[] content = trie.content;
            int index = ChampNode.nodeIndex(content, nodeMap, mask, bit);
            Object node = content[index];
            if (node instanceof ChampNode) {
                ChampNode champNode = (ChampNode)node;
                ChampNode<K> resultNode = ChampDeletion.deleteFrom(champNode, key, hash, shift + 5, payload);
                if (resultNode == champNode) {
                    return trie;
                }
                int dataMap = trie.dataMap;
                int arity = ChampDeletion.arity(dataMap, nodeMap);
                if (arity == 1) {
                    if (ChampDeletion.branchSize(resultNode) == 1) {
                        return resultNode;
                    }
                    return trie.replaceContentAt(index, resultNode);
                }
                if (ChampDeletion.branchSize(resultNode) == 1) {
                    Object[] resultNodes = resultNode.content;
                    assert (resultNodes.length == 1 << payload);
                    return ChampDeletion.inlineDataForNodeWithoutSubNode(resultNodes, 0, index, content, dataMap, nodeMap, shift, payload);
                }
                return trie.replaceContentAt(index, resultNode);
            }
            HashCollisionNode collisionNode = (HashCollisionNode)node;
            int keyIndex = collisionNode.indexOf(key, payload);
            if (keyIndex != -1) {
                Object[] collisionContent = collisionNode.content;
                int inlineThreshold = 2 << payload;
                if (collisionContent.length > inlineThreshold) {
                    return trie.replaceContentAt(index, collisionNode.removeAt(keyIndex, payload));
                }
                assert (collisionContent.length == inlineThreshold);
                return ChampDeletion.inlineDataForNodeWithoutSubNode(collisionContent, keyIndex == 0 ? 1 << payload : 0, index, content, trie.dataMap, nodeMap, shift, payload);
            }
        } else {
            int index;
            Object data;
            int dataMap = trie.dataMap;
            if ((dataMap & bit) == bit && ((data = trie.content[index = ChampNode.index(dataMap, mask, bit) << payload]) == key || data.equals(key))) {
                return trie.removeDataAt(index, bit, payload);
            }
        }
        return trie;
    }

    private static <K> ChampNode<K> inlineDataForNodeWithoutSubNode(Object[] data, int dataIndex, int inlinedNodeIndex, Object[] content, int dataMap, int nodeMap, int shift, int payload) {
        Object key = data[dataIndex];
        int hash = key.hashCode();
        int mask = ChampNode.mask(hash, shift);
        int bit = 1 << mask;
        assert ((dataMap & bit) != bit);
        assert ((nodeMap & bit) == bit);
        int newDataMap = dataMap | bit;
        int newNodeMap = nodeMap & ~bit;
        int keyIndex = ChampNode.index(newDataMap, mask, bit);
        Object[] newContent = payload == 0 ? ArrayCopy.insertAtPushingRight(keyIndex, content, key, inlinedNodeIndex) : ArrayCopy.insertAtPushingRight(keyIndex << payload, content, data, dataIndex, 1 + payload, inlinedNodeIndex);
        return new ChampNode(newDataMap, newNodeMap, newContent);
    }

    private static int branchSize(ChampNode<?> node) {
        int nodeArity = Integer.bitCount(node.nodeMap);
        if (nodeArity == 0) {
            int dataArity = Integer.bitCount(node.dataMap);
            switch (dataArity) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
            }
            return 2;
        }
        return 2;
    }

    private static int arity(int dataMap, int nodeMap) {
        return Integer.bitCount(dataMap) + Integer.bitCount(nodeMap);
    }
}

