/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import javax.inject.Inject;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencyScopeConfiguration;
import org.gradle.api.artifacts.ResolvableConfiguration;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.provider.PropertyFactory;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.internal.tasks.compile.CompilationSourceDirs;
import org.gradle.api.internal.tasks.compile.JavaCompileExecutableUtils;
import org.gradle.api.internal.tasks.testing.TestExecutableUtils;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.BasePluginExtension;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.JvmEcosystemPlugin;
import org.gradle.api.plugins.JvmToolchainsPlugin;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.plugins.internal.DefaultJavaPluginExtension;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.JvmLanguageUtilities;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.reporting.internal.ReportUtilities;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.internal.JavaExecExecutableUtils;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.javadoc.internal.JavadocExecutableUtils;
import org.gradle.api.tasks.testing.JUnitXmlReport;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.Cast;
import org.gradle.internal.jvm.JavaModuleDetector;
import org.gradle.jvm.tasks.Jar;
import org.gradle.jvm.toolchain.JavaCompiler;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.DefaultToolchainSpec;
import org.gradle.language.jvm.tasks.ProcessResources;

public abstract class JavaBasePlugin
implements Plugin<Project> {
    public static final String CHECK_TASK_NAME = "check";
    public static final String VERIFICATION_GROUP = "verification";
    public static final String BUILD_TASK_NAME = "build";
    public static final String BUILD_DEPENDENTS_TASK_NAME = "buildDependents";
    public static final String BUILD_NEEDED_TASK_NAME = "buildNeeded";
    public static final String DOCUMENTATION_GROUP = "documentation";
    public static final String COMPILE_CLASSPATH_PACKAGING_SYSTEM_PROPERTY = "org.gradle.java.compile-classpath-packaging";
    public static final Set<String> UNPUBLISHABLE_VARIANT_ARTIFACTS = JavaConfigurationVariantMapping.UNPUBLISHABLE_VARIANT_ARTIFACTS;
    private final boolean javaClasspathPackaging;
    private final PropertyFactory propertyFactory;
    private final JvmPluginServices jvmPluginServices;

    @Inject
    public JavaBasePlugin(JvmPluginServices jvmPluginServices, PropertyFactory propertyFactory) {
        this.propertyFactory = propertyFactory;
        this.javaClasspathPackaging = Boolean.getBoolean(COMPILE_CLASSPATH_PACKAGING_SYSTEM_PROPERTY);
        this.jvmPluginServices = jvmPluginServices;
    }

    @Inject
    protected abstract JvmLanguageUtilities getJvmLanguageUtils();

    public void apply(Project project) {
        project.getPluginManager().apply(BasePlugin.class);
        project.getPluginManager().apply(JvmEcosystemPlugin.class);
        project.getPluginManager().apply(ReportingBasePlugin.class);
        project.getPluginManager().apply(JvmToolchainsPlugin.class);
        DefaultJavaPluginExtension javaPluginExtension = JavaBasePlugin.addExtensions(project);
        this.configureCompileDefaults(project, javaPluginExtension);
        this.configureSourceSetDefaults(project, javaPluginExtension);
        this.configureJavaDoc(project, javaPluginExtension);
        this.configureTest(project, javaPluginExtension);
        this.configureBuildNeeded(project);
        this.configureBuildDependents(project);
        this.configureArchiveDefaults(project);
        this.configureJavaExecTasks(project);
    }

    private static DefaultJavaPluginExtension addExtensions(Project project) {
        DefaultToolchainSpec toolchainSpec = (DefaultToolchainSpec)project.getObjects().newInstance(DefaultToolchainSpec.class, new Object[0]);
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByName("sourceSets");
        return (DefaultJavaPluginExtension)project.getExtensions().create(JavaPluginExtension.class, "java", DefaultJavaPluginExtension.class, new Object[]{project, sourceSets, toolchainSpec});
    }

    private void configureSourceSetDefaults(Project project, JavaPluginExtension javaPluginExtension) {
        javaPluginExtension.getSourceSets().all(sourceSet -> {
            ConfigurationContainer configurations = project.getConfigurations();
            this.defineConfigurationsForSourceSet((SourceSet)sourceSet, (RoleBasedConfigurationContainerInternal)configurations);
            JavaBasePlugin.definePathsForSourceSet(sourceSet, project);
            this.createProcessResourcesTask((SourceSet)sourceSet, sourceSet.getResources(), project);
            TaskProvider<JavaCompile> compileTask = this.createCompileJavaTask((SourceSet)sourceSet, sourceSet.getJava(), project);
            this.createClassesTask((SourceSet)sourceSet, project);
            this.configureLibraryElements(compileTask, (SourceSet)sourceSet, configurations);
            this.configureTargetPlatform(compileTask, (SourceSet)sourceSet, configurations);
        });
    }

    private void configureLibraryElements(TaskProvider<JavaCompile> compileJava, SourceSet sourceSet, ConfigurationContainer configurations) {
        Configuration compileClasspath = configurations.getByName(sourceSet.getCompileClasspathConfigurationName());
        AttributeContainer compileClasspathAttributes = compileClasspath.getAttributes();
        Provider libraryElements = compileJava.flatMap(x -> x.getModularity().getInferModulePath()).map(inferModulePath -> {
            if (this.javaClasspathPackaging) {
                return "jar";
            }
            List sourcesRoots = CompilationSourceDirs.inferSourceRoots((FileTreeInternal)((FileTreeInternal)sourceSet.getJava().getAsFileTree()));
            if (JavaModuleDetector.isModuleSource((boolean)inferModulePath, (Iterable)sourcesRoots)) {
                return "jar";
            }
            return "classes";
        }).map(value -> (LibraryElements)compileClasspathAttributes.named(LibraryElements.class, value));
        compileClasspathAttributes.attributeProvider(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, libraryElements);
    }

    private void configureTargetPlatform(TaskProvider<JavaCompile> compileTask, SourceSet sourceSet, ConfigurationContainer configurations) {
        this.getJvmLanguageUtils().useDefaultTargetPlatformInference(configurations.getByName(sourceSet.getCompileClasspathConfigurationName()), compileTask);
        this.getJvmLanguageUtils().useDefaultTargetPlatformInference(configurations.getByName(sourceSet.getRuntimeClasspathConfigurationName()), compileTask);
    }

    private TaskProvider<JavaCompile> createCompileJavaTask(SourceSet sourceSet, SourceDirectorySet javaSource, Project project) {
        TaskProvider compileTask = project.getTasks().register(sourceSet.getCompileJavaTaskName(), JavaCompile.class, javaCompile -> {
            ConventionMapping conventionMapping = javaCompile.getConventionMapping();
            conventionMapping.map("classpath", () -> ((SourceSet)sourceSet).getCompileClasspath());
            JvmPluginsHelper.configureAnnotationProcessorPath(sourceSet, javaSource, javaCompile.getOptions(), project);
            javaCompile.setDescription("Compiles " + javaSource + ".");
            javaCompile.setSource((FileTree)javaSource);
            Provider toolchainOverrideSpec = project.provider(() -> JavaCompileExecutableUtils.getExecutableOverrideToolchainSpec((JavaCompile)javaCompile, (PropertyFactory)this.propertyFactory));
            javaCompile.getJavaCompiler().convention(this.getToolchainTool(project, JavaToolchainService::compilerFor, (Provider<JavaToolchainSpec>)toolchainOverrideSpec));
            String generatedHeadersDir = "generated/sources/headers/" + javaSource.getName() + "/" + sourceSet.getName();
            javaCompile.getOptions().getHeaderOutputDirectory().convention(project.getLayout().getBuildDirectory().dir(generatedHeadersDir));
            JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            javaCompile.getModularity().getInferModulePath().convention((Provider)javaPluginExtension.getModularity().getInferModulePath());
        });
        JvmPluginsHelper.configureOutputDirectoryForSourceSet(sourceSet, javaSource, project, (TaskProvider<? extends AbstractCompile>)compileTask, (Provider<CompileOptions>)compileTask.map(JavaCompile::getOptions));
        return compileTask;
    }

    private void createProcessResourcesTask(SourceSet sourceSet, SourceDirectorySet resourceSet, Project target) {
        TaskProvider processResources = target.getTasks().register(sourceSet.getProcessResourcesTaskName(), ProcessResources.class, resourcesTask -> {
            resourcesTask.setDescription("Processes " + resourceSet + ".");
            new DslObject((Object)resourcesTask.getRootSpec()).getConventionMapping().map("destinationDir", () -> sourceSet.getOutput().getResourcesDir());
            resourcesTask.from(new Object[]{resourceSet});
        });
        DefaultSourceSetOutput output = (DefaultSourceSetOutput)Cast.uncheckedCast((Object)sourceSet.getOutput());
        output.setResourcesContributor(processResources.map(Copy::getDestinationDir), processResources);
    }

    private void createClassesTask(SourceSet sourceSet, Project target) {
        sourceSet.compiledBy(new Object[]{target.getTasks().register(sourceSet.getClassesTaskName(), classesTask -> {
            classesTask.setGroup(BUILD_TASK_NAME);
            classesTask.setDescription("Assembles " + sourceSet.getOutput() + ".");
            classesTask.dependsOn(new Object[]{sourceSet.getOutput().getDirs()});
            classesTask.dependsOn(new Object[]{sourceSet.getCompileJavaTaskName()});
            classesTask.dependsOn(new Object[]{sourceSet.getProcessResourcesTaskName()});
        })});
    }

    private static void definePathsForSourceSet(SourceSet sourceSet, Project project) {
        ConventionMapping outputConventionMapping = ((IConventionAware)sourceSet.getOutput()).getConventionMapping();
        outputConventionMapping.map("resourcesDir", () -> {
            String classesDirName = "resources/" + sourceSet.getName();
            return ((Directory)project.getLayout().getBuildDirectory().dir(classesDirName).get()).getAsFile();
        });
        sourceSet.getJava().srcDir((Object)("src/" + sourceSet.getName() + "/java"));
        sourceSet.getResources().srcDir((Object)("src/" + sourceSet.getName() + "/resources"));
    }

    private void defineConfigurationsForSourceSet(SourceSet sourceSet, RoleBasedConfigurationContainerInternal configurations) {
        String implementationConfigurationName = sourceSet.getImplementationConfigurationName();
        String runtimeOnlyConfigurationName = sourceSet.getRuntimeOnlyConfigurationName();
        String compileOnlyConfigurationName = sourceSet.getCompileOnlyConfigurationName();
        String compileClasspathConfigurationName = sourceSet.getCompileClasspathConfigurationName();
        String annotationProcessorConfigurationName = sourceSet.getAnnotationProcessorConfigurationName();
        String runtimeClasspathConfigurationName = sourceSet.getRuntimeClasspathConfigurationName();
        String sourceSetName = sourceSet.toString();
        DependencyScopeConfiguration implementationConfiguration = configurations.dependencyScopeLocked(implementationConfigurationName, conf -> conf.setDescription("Implementation only dependencies for " + sourceSetName + "."));
        DependencyScopeConfiguration compileOnlyConfiguration = configurations.dependencyScopeLocked(compileOnlyConfigurationName, conf -> conf.setDescription("Compile only dependencies for " + sourceSetName + "."));
        ResolvableConfiguration compileClasspathConfiguration = configurations.resolvableLocked(compileClasspathConfigurationName, arg_0 -> this.lambda$defineConfigurationsForSourceSet$12((Configuration)compileOnlyConfiguration, (Configuration)implementationConfiguration, sourceSetName, arg_0));
        Configuration annotationProcessorConfiguration = configurations.resolvableDependencyScopeLocked(annotationProcessorConfigurationName, conf -> {
            conf.setDescription("Annotation processors and their dependencies for " + sourceSetName + ".");
            this.jvmPluginServices.configureAsRuntimeClasspath((HasConfigurableAttributes)conf);
        });
        DependencyScopeConfiguration runtimeOnlyConfiguration = configurations.dependencyScopeLocked(runtimeOnlyConfigurationName, conf -> conf.setDescription("Runtime only dependencies for " + sourceSetName + "."));
        ResolvableConfiguration runtimeClasspathConfiguration = configurations.resolvableLocked(runtimeClasspathConfigurationName, arg_0 -> this.lambda$defineConfigurationsForSourceSet$15(sourceSetName, (Configuration)runtimeOnlyConfiguration, (Configuration)implementationConfiguration, arg_0));
        sourceSet.setCompileClasspath((FileCollection)compileClasspathConfiguration);
        sourceSet.setRuntimeClasspath(sourceSet.getOutput().plus((FileCollection)runtimeClasspathConfiguration));
        sourceSet.setAnnotationProcessorPath((FileCollection)annotationProcessorConfiguration);
    }

    private void configureCompileDefaults(Project project, DefaultJavaPluginExtension javaExtension) {
        project.getTasks().withType(AbstractCompile.class).configureEach(compile -> JvmPluginsHelper.configureCompileDefaults(compile, javaExtension, (rawConvention, javaVersionSupplier) -> {
            if (compile instanceof JavaCompile) {
                JavaCompile javaCompile = (JavaCompile)compile;
                if (javaCompile.getOptions().getRelease().isPresent()) {
                    return JavaVersion.toVersion((Object)javaCompile.getOptions().getRelease().get());
                }
                if (rawConvention != null) {
                    return rawConvention;
                }
                return JavaVersion.toVersion((Object)((JavaCompiler)javaCompile.getJavaCompiler().get()).getMetadata().getLanguageVersion().toString());
            }
            return (JavaVersion)javaVersionSupplier.get();
        }));
    }

    private void configureJavaDoc(Project project, JavaPluginExtension javaPluginExtension) {
        project.getTasks().withType(Javadoc.class).configureEach(javadoc -> {
            javadoc.getConventionMapping().map("destinationDir", () -> ((Directory)javaPluginExtension.getDocsDir().dir("javadoc").get()).getAsFile());
            javadoc.getConventionMapping().map("title", () -> ReportUtilities.getApiDocTitleFor((Project)project));
            Provider toolchainOverrideSpec = project.provider(() -> JavadocExecutableUtils.getExecutableOverrideToolchainSpec((Javadoc)javadoc, (PropertyFactory)this.propertyFactory));
            javadoc.getJavadocTool().convention(this.getToolchainTool(project, JavaToolchainService::javadocToolFor, (Provider<JavaToolchainSpec>)toolchainOverrideSpec));
        });
    }

    private void configureBuildNeeded(Project project) {
        project.getTasks().register(BUILD_NEEDED_TASK_NAME, buildTask -> {
            buildTask.setDescription("Assembles and tests this project and all projects it depends on.");
            buildTask.setGroup(BUILD_TASK_NAME);
            buildTask.dependsOn(new Object[]{BUILD_TASK_NAME});
        });
    }

    private void configureBuildDependents(Project project) {
        project.getTasks().register(BUILD_DEPENDENTS_TASK_NAME, buildTask -> {
            buildTask.setDescription("Assembles and tests this project and all projects that depend on it.");
            buildTask.setGroup(BUILD_TASK_NAME);
            buildTask.dependsOn(new Object[]{BUILD_TASK_NAME});
        });
    }

    private void configureArchiveDefaults(Project project) {
        BasePluginExtension basePluginExtension = (BasePluginExtension)project.getExtensions().getByType(BasePluginExtension.class);
        project.getTasks().withType(Jar.class).configureEach(task -> task.getDestinationDirectory().convention((Provider)basePluginExtension.getLibsDirectory()));
    }

    private void configureTest(Project project, JavaPluginExtension javaPluginExtension) {
        project.getTasks().withType(Test.class).configureEach(test -> this.configureTestDefaults((Test)test, project, javaPluginExtension));
    }

    private void configureTestDefaults(Test test, Project project, JavaPluginExtension javaPluginExtension) {
        DirectoryReport htmlReport = test.getReports().getHtml();
        JUnitXmlReport xmlReport = test.getReports().getJunitXml();
        xmlReport.getOutputLocation().convention(javaPluginExtension.getTestResultsDir().dir(test.getName()));
        htmlReport.getOutputLocation().convention(javaPluginExtension.getTestReportDir().dir(test.getName()));
        test.getBinaryResultsDirectory().convention(javaPluginExtension.getTestResultsDir().dir(test.getName() + "/binary"));
        test.workingDir((Object)project.getProjectDir());
        Provider toolchainOverrideSpec = project.provider(() -> TestExecutableUtils.getExecutableToolchainSpec((Test)test, (PropertyFactory)this.propertyFactory));
        test.getJavaLauncher().convention(this.getToolchainTool(project, JavaToolchainService::launcherFor, (Provider<JavaToolchainSpec>)toolchainOverrideSpec));
    }

    private void configureJavaExecTasks(Project project) {
        project.getTasks().withType(JavaExec.class).configureEach(javaExec -> {
            Provider toolchainOverrideSpec = project.provider(() -> JavaExecExecutableUtils.getExecutableOverrideToolchainSpec((JavaExec)javaExec, (PropertyFactory)this.propertyFactory));
            javaExec.getJavaLauncher().convention(this.getToolchainTool(project, JavaToolchainService::launcherFor, (Provider<JavaToolchainSpec>)toolchainOverrideSpec));
        });
    }

    private <T> Provider<T> getToolchainTool(Project project, BiFunction<JavaToolchainService, JavaToolchainSpec, Provider<T>> toolMapper, Provider<JavaToolchainSpec> toolchainOverride) {
        JavaToolchainService service = (JavaToolchainService)project.getExtensions().getByType(JavaToolchainService.class);
        JavaPluginExtension extension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        return toolchainOverride.orElse((Object)extension.getToolchain()).flatMap(spec -> (Provider)toolMapper.apply(service, (JavaToolchainSpec)spec));
    }

    private /* synthetic */ void lambda$defineConfigurationsForSourceSet$15(String sourceSetName, Configuration runtimeOnlyConfiguration, Configuration implementationConfiguration, Configuration conf) {
        conf.setDescription("Runtime classpath of " + sourceSetName + ".");
        conf.extendsFrom(new Configuration[]{runtimeOnlyConfiguration, implementationConfiguration});
        this.jvmPluginServices.configureAsRuntimeClasspath((HasConfigurableAttributes)conf);
    }

    private /* synthetic */ void lambda$defineConfigurationsForSourceSet$12(Configuration compileOnlyConfiguration, Configuration implementationConfiguration, String sourceSetName, Configuration conf) {
        conf.extendsFrom(new Configuration[]{compileOnlyConfiguration, implementationConfiguration});
        conf.setDescription("Compile classpath for " + sourceSetName + ".");
        this.jvmPluginServices.configureAsCompileClasspath((HasConfigurableAttributes)conf);
    }
}

