/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.console;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.fusesource.jansi.io.WindowsAnsiProcessor;
import org.gradle.internal.nativeintegration.console.ConsoleDetector;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;
import org.gradle.internal.nativeintegration.console.FallbackConsoleMetaData;
import org.gradle.internal.nativeintegration.console.NativePlatformConsoleDetector;
import org.gradle.internal.nativeintegration.console.UnicodeProxyConsoleMetaData;

public class WindowsConsoleDetector
implements ConsoleDetector {
    @Override
    public ConsoleMetaData getConsole() {
        try {
            new WindowsAnsiProcessor((OutputStream)new PrintStream(new ByteArrayOutputStream()), true);
            final boolean disableUnicodeSupportDetection = NativePlatformConsoleDetector.isWindowsWithNonUnicodeCodePage();
            return new UnicodeProxyConsoleMetaData(FallbackConsoleMetaData.ATTACHED){

                @Override
                public boolean supportsUnicode() {
                    if (disableUnicodeSupportDetection) {
                        return false;
                    }
                    return this.metaData.supportsUnicode();
                }
            };
        }
        catch (IOException ignore) {
            return null;
        }
    }

    @Override
    public boolean isConsoleInput() {
        return System.console() != null;
    }
}

