/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.gradle.internal.resource.ReadableContent;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface HttpClient
extends Closeable {
    public Response performHead(URI var1, ImmutableMap<String, String> var2);

    public Response performGet(URI var1, ImmutableMap<String, String> var2);

    public Response performRawGet(URI var1, ImmutableMap<String, String> var2) throws IOException;

    public Response performRawPut(URI var1, ReadableContent var2) throws IOException;

    public Response performRawPut(URI var1, ImmutableMap<String, String> var2, WritableContent var3) throws IOException;

    public static interface WritableContent {
        public void writeTo(OutputStream var1) throws IOException;

        public long getSize();
    }

    public static interface Response
    extends Closeable {
        public @Nullable String getHeader(String var1);

        public InputStream getContent() throws IOException;

        public int getStatusCode();

        public String getStatusReason();

        public String getMethod();

        public URI getEffectiveUri();

        default public boolean isSuccessful() {
            int statusCode = this.getStatusCode();
            return statusCode >= 200 && statusCode < 400;
        }

        default public boolean isMissing() {
            return this.getStatusCode() == 404;
        }

        @Override
        public void close();
    }
}

