/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.Serializable;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.ExtensiblePolymorphicDomainObjectContainer;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.attributes.TestSuiteName;
import org.gradle.api.attributes.VerificationType;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.tasks.testing.DefaultAggregateTestReport;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.testing.AggregateTestReport;
import org.gradle.testing.base.TestSuite;
import org.gradle.testing.base.TestingExtension;

@Incubating
public abstract class TestReportAggregationPlugin
implements Plugin<Project> {
    public static final String TEST_REPORT_AGGREGATION_CONFIGURATION_NAME = "testReportAggregation";

    @Inject
    protected abstract JvmPluginServices getJvmPluginServices();

    public void apply(Project project) {
        project.getPluginManager().apply("org.gradle.reporting-base");
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration testAggregation = (Configuration)configurations.dependencyScope(TEST_REPORT_AGGREGATION_CONFIGURATION_NAME, dependencyScope -> dependencyScope.setDescription("A configuration to collect test execution results.")).get();
        Configuration testResultsConf = (Configuration)configurations.resolvable("aggregateTestReportResults", resolvable -> {
            resolvable.extendsFrom(new Configuration[]{testAggregation});
            resolvable.setDescription("Graph needed for the aggregated test results report.");
        }).get();
        ReportingExtension reporting = (ReportingExtension)project.getExtensions().getByType(ReportingExtension.class);
        reporting.getReports().registerBinding(AggregateTestReport.class, DefaultAggregateTestReport.class);
        ObjectFactory objects = project.getObjects();
        DirectoryProperty testReportDirectory = objects.directoryProperty().convention(reporting.getBaseDirectory().dir("tests"));
        project.getPlugins().withId("java-base", plugin -> {
            JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            testReportDirectory.convention((Provider)javaPluginExtension.getTestReportDir());
            this.getJvmPluginServices().configureAsRuntimeClasspath((HasConfigurableAttributes)testResultsConf);
        });
        reporting.getReports().withType(AggregateTestReport.class).all(report -> report.getReportTask().configure(task -> {
            Callable<FileCollection> testResults = () -> testResultsConf.getIncoming().artifactView(view -> {
                view.withVariantReselection();
                view.componentFilter(SerializableLambdas.spec((SerializableLambdas.SerializableSpec & Serializable)id -> id instanceof ProjectComponentIdentifier));
                view.attributes(attributes -> {
                    attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)attributes.named(Category.class, "verification")));
                    attributes.attributeProvider(TestSuiteName.TEST_SUITE_NAME_ATTRIBUTE, report.getTestSuiteName().map(tt -> (TestSuiteName)attributes.named(TestSuiteName.class, tt)));
                    attributes.attribute(VerificationType.VERIFICATION_TYPE_ATTRIBUTE, (Object)((VerificationType)attributes.named(VerificationType.class, "test-results")));
                });
            }).getFiles();
            task.getTestResults().from(new Object[]{testResults});
            task.getDestinationDirectory().convention(testReportDirectory.dir(report.getTestSuiteName().map(tt -> tt + "/aggregated-results")));
        }));
        project.getPlugins().withId("test-suite-base", plugin -> {
            testAggregation.getDependencies().add((Object)project.getDependencyFactory().create(project));
            TestingExtension testing = (TestingExtension)project.getExtensions().getByType(TestingExtension.class);
            ExtensiblePolymorphicDomainObjectContainer testSuites = testing.getSuites();
            testSuites.withType(TestSuite.class).all(testSuite -> reporting.getReports().create(testSuite.getName() + "AggregateTestReport", AggregateTestReport.class, report -> report.getTestSuiteName().convention((Object)testSuite.getName())));
        });
    }
}

