/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.strict;

import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.internal.collect.PersistentSet;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class StrictVersionConstraints {
    public static final StrictVersionConstraints EMPTY = new StrictVersionConstraints(PersistentSet.of()){

        @Override
        public StrictVersionConstraints union(StrictVersionConstraints other) {
            return other;
        }

        @Override
        public StrictVersionConstraints intersect(StrictVersionConstraints other) {
            return EMPTY;
        }

        @Override
        public StrictVersionConstraints minus(StrictVersionConstraints other) {
            return EMPTY;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(ModuleIdentifier module) {
            return false;
        }

        @Override
        public String toString() {
            return "no modules";
        }
    };
    private final PersistentSet<ModuleIdentifier> modules;

    private StrictVersionConstraints(PersistentSet<ModuleIdentifier> modules) {
        this.modules = modules;
    }

    public static StrictVersionConstraints of(PersistentSet<ModuleIdentifier> modules) {
        if (modules.isEmpty()) {
            return EMPTY;
        }
        return new StrictVersionConstraints(modules);
    }

    public PersistentSet<ModuleIdentifier> getModules() {
        return this.modules;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public boolean contains(ModuleIdentifier module) {
        return this.modules.contains((Object)module);
    }

    public StrictVersionConstraints union(StrictVersionConstraints other) {
        if (other == EMPTY) {
            return this;
        }
        if (this == other) {
            return this;
        }
        PersistentSet union = this.modules.union(other.modules);
        if (union == this.modules) {
            return this;
        }
        return StrictVersionConstraints.of((PersistentSet<ModuleIdentifier>)union);
    }

    public StrictVersionConstraints intersect(StrictVersionConstraints other) {
        if (other == EMPTY) {
            return EMPTY;
        }
        if (this == other) {
            return this;
        }
        PersistentSet intersect = this.modules.intersect(other.modules);
        if (intersect == this.modules) {
            return this;
        }
        return StrictVersionConstraints.of((PersistentSet<ModuleIdentifier>)intersect);
    }

    public String toString() {
        return "modules=" + this.modules;
    }

    public StrictVersionConstraints minus(StrictVersionConstraints other) {
        if (other == EMPTY) {
            return this;
        }
        if (this == other) {
            return EMPTY;
        }
        PersistentSet diff = this.modules.except(other.modules);
        if (diff == this.modules) {
            return this;
        }
        return StrictVersionConstraints.of((PersistentSet<ModuleIdentifier>)diff);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StrictVersionConstraints that = (StrictVersionConstraints)o;
        return this.modules.equals(that.modules);
    }

    public int hashCode() {
        return this.modules.hashCode();
    }
}

