/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.ClassPathProvider;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.classpath.PluginModuleRegistry;
import org.gradle.api.specs.Spec;
import org.gradle.internal.classpath.ClassPath;
import org.jspecify.annotations.Nullable;

public class DynamicModulesClassPathProvider
implements ClassPathProvider {
    private final ModuleRegistry moduleRegistry;
    private final PluginModuleRegistry pluginModuleRegistry;
    private final JavaVersion javaVersion;
    private static final ImmutableList<String> GRADLE_EXTENSION_MODULES = ImmutableList.of((Object)"gradle-workers", (Object)"gradle-dependency-management", (Object)"gradle-software-diagnostics", (Object)"gradle-plugin-use", (Object)"gradle-instrumentation-declarations");
    private static final ImmutableList<String> GRADLE_OPTIONAL_EXTENSION_MODULES = ImmutableList.of((Object)"gradle-daemon-services", (Object)"gradle-kotlin-dsl-provider-plugins", (Object)"gradle-kotlin-dsl-tooling-builders");

    public DynamicModulesClassPathProvider(ModuleRegistry moduleRegistry, PluginModuleRegistry pluginModuleRegistry) {
        this(moduleRegistry, pluginModuleRegistry, JavaVersion.current());
    }

    @VisibleForTesting
    protected DynamicModulesClassPathProvider(ModuleRegistry moduleRegistry, PluginModuleRegistry pluginModuleRegistry, JavaVersion javaVersion) {
        this.moduleRegistry = moduleRegistry;
        this.pluginModuleRegistry = pluginModuleRegistry;
        this.javaVersion = javaVersion;
    }

    public @Nullable ClassPath findClassPath(String name) {
        if (name.equals("GRADLE_EXTENSIONS")) {
            return this.gradleExtensionsWithout((Iterable<String>)ImmutableList.of((Object)"gradle-core"));
        }
        if (name.equals("GRADLE_WORKER_EXTENSIONS")) {
            return this.gradleExtensionsWithout((Iterable<String>)ImmutableList.of((Object)"gradle-core", (Object)"gradle-workers", (Object)"gradle-dependency-management"));
        }
        return null;
    }

    private ClassPath gradleExtensionsWithout(Iterable<String> modulesToExclude) {
        ImmutableSet coreModules = ImmutableSet.copyOf(this.allRequiredModulesOf(modulesToExclude));
        ClassPath classpath = ClassPath.EMPTY;
        List<Module> extensionModules = this.allRequiredModulesOf((Iterable<String>)GRADLE_EXTENSION_MODULES);
        classpath = DynamicModulesClassPathProvider.plusExtensionModules(classpath, extensionModules, (Set<Module>)coreModules);
        List<Module> optionalExtensionModules = this.allRequiredModulesOfOptional((Collection<String>)GRADLE_OPTIONAL_EXTENSION_MODULES);
        classpath = DynamicModulesClassPathProvider.plusExtensionModules(classpath, optionalExtensionModules, (Set<Module>)coreModules);
        classpath = classpath.plus(this.moduleRegistry.getRuntimeClasspath(Iterables.concat(this.pluginModuleRegistry.getApiModules(), this.pluginModuleRegistry.getImplementationModules())));
        return this.removeJaxbIfIncludedInCurrentJdk(classpath);
    }

    private ClassPath removeJaxbIfIncludedInCurrentJdk(ClassPath classpath) {
        if (!this.javaVersion.isJava9Compatible()) {
            return classpath.removeIf((Spec)new Spec<File>(){

                public boolean isSatisfiedBy(File file) {
                    return file.getName().startsWith("jaxb-impl-");
                }
            });
        }
        return classpath;
    }

    private List<Module> allRequiredModulesOf(Iterable<String> names) {
        Iterable modules = Iterables.transform(names, arg_0 -> ((ModuleRegistry)this.moduleRegistry).getModule(arg_0));
        return this.moduleRegistry.getRuntimeModules(modules);
    }

    private List<Module> allRequiredModulesOfOptional(Collection<String> names) {
        ArrayList<Module> modules = new ArrayList<Module>(names.size());
        for (String name : names) {
            Module optionalModule = this.moduleRegistry.findModule(name);
            if (optionalModule == null) continue;
            modules.add(optionalModule);
        }
        return this.moduleRegistry.getRuntimeModules(modules);
    }

    private static ClassPath plusExtensionModules(ClassPath classpath, List<Module> extensionModules, Set<Module> coreModules) {
        for (Module module : extensionModules) {
            if (coreModules.contains(module)) continue;
            classpath = classpath.plus(module.getImplementationClasspath());
        }
        return classpath;
    }
}

