/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.artifacts.JavaEcosystemSupport;
import org.gradle.api.internal.artifacts.dsl.ComponentMetadataHandlerInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.TargetJVMVersionOnLibraryTooNewFailureDescriber;
import org.gradle.api.internal.attributes.AttributeDescriberRegistry;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.internal.component.external.model.JavaEcosystemVariantDerivationStrategy;
import org.gradle.internal.component.external.model.VariantDerivationStrategy;
import org.gradle.internal.component.resolution.failure.ResolutionFailureHandler;
import org.gradle.internal.component.resolution.failure.type.NoCompatibleVariantsFailure;

public abstract class JvmEcosystemPlugin
implements Plugin<Project> {
    private final ObjectFactory objectFactory;
    private final SourceSetContainer sourceSets;

    @Inject
    public JvmEcosystemPlugin(ObjectFactory objectFactory, SourceSetContainer sourceSets) {
        this.objectFactory = objectFactory;
        this.sourceSets = sourceSets;
    }

    public void apply(Project project) {
        ProjectInternal p = (ProjectInternal)project;
        project.getExtensions().add(SourceSetContainer.class, "sourceSets", (Object)this.sourceSets);
        this.configureVariantDerivationStrategy(p);
        this.configureSchema(p);
    }

    private void configureVariantDerivationStrategy(ProjectInternal project) {
        ComponentMetadataHandlerInternal metadataHandler = (ComponentMetadataHandlerInternal)project.getDependencies().getComponents();
        metadataHandler.setVariantDerivationStrategy((VariantDerivationStrategy)this.objectFactory.newInstance(JavaEcosystemVariantDerivationStrategy.class, new Object[0]));
    }

    private void configureSchema(ProjectInternal project) {
        AttributesSchemaInternal attributesSchema = (AttributesSchemaInternal)project.getDependencies().getAttributesSchema();
        ResolutionFailureHandler handler = (ResolutionFailureHandler)project.getServices().get(ResolutionFailureHandler.class);
        AttributeDescriberRegistry attributeDescribers = (AttributeDescriberRegistry)project.getServices().get(AttributeDescriberRegistry.class);
        JavaEcosystemSupport.configureServices((AttributesSchema)attributesSchema, (AttributeDescriberRegistry)attributeDescribers, (ObjectFactory)this.objectFactory);
        handler.addFailureDescriber(NoCompatibleVariantsFailure.class, TargetJVMVersionOnLibraryTooNewFailureDescriber.class);
        AttributeContainer attrs = ((ArtifactTypeDefinition)project.getDependencies().getArtifactTypes().create("jar")).getAttributes();
        attrs.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)attrs.named(Usage.class, "java-runtime")));
        attrs.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)attrs.named(LibraryElements.class, "jar")));
    }
}

