/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.util.function.Supplier;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CacheCleanupStrategyFactory;
import org.gradle.cache.CleanupFrequency;
import org.gradle.cache.FineGrainedCacheCleanupStrategyFactory;
import org.gradle.cache.FineGrainedMarkAndSweepCacheCleanupStrategy;
import org.gradle.cache.FineGrainedPersistentCache;
import org.gradle.cache.internal.FineGrainedMarkAndSweepLeastRecentlyUsedCacheCleanup;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class DefaultFineGrainedCacheCleanupStrategyFactory
implements FineGrainedCacheCleanupStrategyFactory {
    private final FileAccessTimeJournal fileAccessTimeJournal;
    private final CacheCleanupStrategyFactory cacheCleanupStrategyFactory;

    public DefaultFineGrainedCacheCleanupStrategyFactory(CacheCleanupStrategyFactory cacheCleanupStrategyFactory, FileAccessTimeJournal fileAccessTimeJournal) {
        this.cacheCleanupStrategyFactory = cacheCleanupStrategyFactory;
        this.fileAccessTimeJournal = fileAccessTimeJournal;
    }

    @Override
    public FineGrainedMarkAndSweepCacheCleanupStrategy markAndSweepCleanupStrategy(Supplier<Long> cacheEntryRetentionTimestamp, Supplier<CleanupFrequency> frequency) {
        final FineGrainedMarkAndSweepLeastRecentlyUsedCacheCleanup cleanup = new FineGrainedMarkAndSweepLeastRecentlyUsedCacheCleanup(this.fileAccessTimeJournal, cacheEntryRetentionTimestamp);
        final CacheCleanupStrategy cacheCleanupStrategy = this.cacheCleanupStrategyFactory.create(cleanup, frequency);
        return new FineGrainedMarkAndSweepCacheCleanupStrategy(){

            @Override
            public FineGrainedMarkAndSweepCacheCleanupStrategy.FineGrainedCacheEntrySoftDeleter getSoftDeleter(FineGrainedPersistentCache cache) {
                return cleanup.getSoftDeleter(cache);
            }

            @Override
            public CacheCleanupStrategy getCleanupStrategy() {
                return cacheCleanupStrategy;
            }
        };
    }
}

